# include <R.h> 
# include <Rmath.h> 
# include <R_ext/Lapack.h> 

void myinv(int *p, double *mat, double *res) {
  int i, info=0, ipvt[*p];
  for (i=0; i<*p*(*p); i++) 
    res[i] = 0;
  for (i=0; i<*p; i++) 
    res[i*(*p+1)] = 1;
  F77_NAME(dgesv)(p, p, mat, p, ipvt, res, p, &info);
}

void mycsolve(int *p, double *mat, int *p2, double *res) {
  int i, info=0, ipvt[*p];
  F77_NAME(dgesv)(p, p2, mat, p, ipvt, res, p, &info);
}

void ldet(int *n, double *mat, double *ldet, int *sign) {
  int i, id, info=0, jpvt[*n];
  *sign = 1;
  F77_NAME(dgetrf)(n, n, mat, n, jpvt, &info);
  for (i = 0; i < *n; i++)
    if (jpvt[i] != (i + 1))
      *sign = -*sign;
  *ldet = 0.0;
  for (i=0; i<*n; i++) {
    id = i*(*n+1);
    if (mat[id]<0) {
      *ldet += log(-mat[id]);
      *sign = -*sign;
    }
    else
      *ldet += log(mat[id]);
  }
}

void mycmahalanobis(int *p, double *x, double *m, double *q, double *res) {
  int i, j, id, p2=1, info=0, ipvt[*p];
  double d[*p], aux[*p];
  for (i=0; i<*p; i++) {
    d[i] = x[i] - m[i];
    aux[i] = d[i];
  }
  F77_NAME(dgesv)(p, &p2, q, p, ipvt, aux, p, &info);
  *res = 0.0;
  for (i=0; i<*p; i++) 
    *res += aux[i]*d[i];
}

void lpostgeo(int *n, double *pars, double *y, double *m, 
	      double *sdists, double *mcov, double *imcov,  
	      double *lpost) {
  int i, sign;
  double logdet, tmp1=0.0, aux = -0.9189385*(float)(*n); 
  for (i=0; i<*n*(*n); i++) 
    mcov[i] = pars[1]*exp(-sdists[i]/pars[2]);  
  ldet(n, mcov, &logdet, &sign);
  for (i=0; i<*n*(*n); i++) 
    mcov[i] = pars[1]*exp(-sdists[i]/pars[2]);  
  for (i=0; i<*n; i++) 
    m[i] = pars[0];
  mycmahalanobis(n, y, m, mcov, &tmp1);
  aux -= 0.5*(tmp1 + logdet);
  aux += dnorm(pars[0], 0.0, 10.0, 1); 
  aux += dgamma(pars[1], 1.1, 0.1, 1);
  aux += dgamma(pars[2], 1.1, 1/0.1, 1);
  *lpost = aux;
}

void geomcmc(int *n, double *y, double *m, 
	     double *sdists, double *mcov, double *imcov, 
	     int *nmc, double *tune, double *res, 
	     int *acc, int *verbose) {
  int mc, i, id=0, sn;
  double atpost=0.0, oldpost=0.0, rpost, prop, atpars[3], racc, lru;
  for (i=0; i<3; i++) 
    atpars[i] = res[i];
  lpostgeo(n, atpars, y, m, sdists, mcov, imcov, &oldpost);
  GetRNGstate();
  for (mc=0; mc<*nmc; mc++) {
    id += 3;
    // atualiza primeiro parametro
    prop = rnorm(res[id-3], tune[0]);
    atpars[0] = prop;
    lpostgeo(n, atpars, y, m, sdists, mcov, imcov, &atpost);
    rpost = atpost - oldpost;
    lru = log(runif(0.0, 1.0));
    if (rpost > lru) {
      res[id] = prop;
      oldpost = atpost;
      acc[0]++;
    }
    else {
      atpars[0] = res[id-3];
      res[id] = res[id-3];
    }
    // atualiza segundo parametro
    prop = rlnorm(log(res[id-2]), tune[1]);
    atpars[1] = prop;
    lpostgeo(n, atpars, y, m, sdists, mcov, imcov, &atpost);
    rpost = atpost - oldpost;
    lru = log(runif(0.0, 1.0));
    if (rpost > lru) {
      res[id+1] = prop;
      oldpost = atpost;
      acc[1]++;
    }
    else {
      atpars[1] = res[id-2];
      res[id+1] = res[id-2];
    }
    // atualiza terceiro parametro 
    prop = rlnorm(log(res[id-1]), tune[2]);
    atpars[2] = prop; 
    lpostgeo(n, atpars, y, m, sdists, mcov, imcov, &atpost);
    rpost = atpost - oldpost;
    lru = log(runif(0.0, 1.0));
    if (rpost > lru) {
      res[id+2] = prop;
      oldpost = atpost;
      acc[2]++;
    }
    else {
      atpars[2] = res[id-1];
      res[id+2] = res[id-1];
    }
    if (*verbose>0 & (mc%*verbose)==0) {
      Rprintf("mc = %d, ll = %5.2f, r = %f, m = %5.2f, s = %5.2f, phi = %5.2f, tune (%5.2f, %5.2f, %5.2f) and acc = (%d, %d, %d)\n", 
	      mc, atpost, rpost, res[id], res[id+1], res[id+2], 
	      tune[0], tune[1], tune[2], acc[0], acc[1], acc[2]);
      for (i=0; i<3; i++) {
	racc = (float)acc[i]/(float)*nmc;
	if (racc>0.4)
	  tune[i] *= 1.2;
	if (racc<0.25)
	  tune[i] /= 1.2;
      }
    }
  }
  PutRNGstate();
}

