cgeomcmc <- function(g, inipars, nmcmc=1000, tune=rep(1,3), verbose=TRUE) {
  sdists <- as.matrix(dist(g$coords))
  n <- ncol(sdists)
  if (length(inipars)!=3)
    stop("inipars must be vector of length equal 3!")
  res <- .C("geomcmc", as.integer(n),
            as.double(g$data), double(n),
            as.double(sdists), double(n^2), double(n^2), 
            as.integer(nmcmc), as.double(tune),
            res=as.double(c(inipars, rep(0,nmcmc*3))),
            acc=integer(3), as.integer(verbose),
            PACKAGE="mypkg")
  acc <- res$acc/nmcmc
  res <- t(matrix(res$res, 3))
  attr(res, "acc") <- acc
  return(res)
}
