// Zero-and-one augmented beta random effects model (ZOAB)
#include <TMB.hpp>

template<class Type>
Type objective_function<Type>::operator() ()
{
  DATA_VECTOR(y);          // Observations
  DATA_SPARSE_MATRIX(X);   // Fixed effect design matrix
  PARAMETER_VECTOR(beta);  // Fixed effects vector for mu
  PARAMETER_VECTOR(gamma); // Fixed effects vector for p0
  PARAMETER_VECTOR(delta); // Fixed effects vector for p1
  DATA_SPARSE_MATRIX(Z);   // Random effect design matrix fou u
  DATA_SPARSE_MATRIX(S);   // Fixed effect design matrix for p0
  DATA_SPARSE_MATRIX(W);   // Fixed effect design matrix for p1
  PARAMETER_VECTOR(u);     // Random effects vector
  PARAMETER(logsdu);       // Random effect standard deviations
  PARAMETER(logphi);       // Precision parameter (Beta distribution)

  // Parametrization
    Type phi = exp(logphi); 
    Type sdu = exp(logsdu);

  // Distribution of random effect (u):
    Type nll3 = 0;
    nll3 -= dnorm(u, Type(0), sdu, true).sum();
  
  // Distribution of obs given random effects (y|u):
    vector<Type> mu = exp(X*beta + Z*u)/(1 + exp(X*beta + Z*u)); 
  
  // Linear predictor for zero inflated
    vector<Type> p0 = exp(S*gamma)/(1 + exp(S*gamma));
    
  // Linear predictor for one inflated
    vector<Type> p1 = exp(W*delta)/(1 + exp(W*delta)); 
    
  // Shape A (Beta)
    vector<Type> shapeA(y.size());
    shapeA = mu*phi;
    
  // Shape B (Beta)
    vector<Type> shapeB(y.size());
    shapeB = (1-mu)*phi;
    
  // Log-likelihood
    Type nll1 = 0;
    Type nll2 = 0;
    for(int i=0; i<y.size(); i++)
    
    if (y(i)==0) nll1 -= log(p0(i)); // Zero augmented
        else
         if (y(i)==1) nll2 -= log(p1(i)); // One augmented
          else nll3 -= log((1-p0(i)-p1(i))) + dbeta(y(i), shapeA(i), shapeB(i), true);
  
  // Report 
    ADREPORT(sdu);
    ADREPORT(phi);

  return nll1 + nll2 + nll3;
}

