// Zero-and-one augmented unit gamma random effects model (ZOAUG)
#include <TMB.hpp>

template<class Type>
Type objective_function<Type>::operator() ()
{
  DATA_VECTOR(y);          // Observations
  DATA_SPARSE_MATRIX(X);   // Fixed effect design matrix
  PARAMETER_VECTOR(beta);  // Fixed effects vector for mu
  PARAMETER_VECTOR(gamma); // Fixed effects vector for p0
  PARAMETER_VECTOR(delta); // Fixed effects vector for p1
  DATA_SPARSE_MATRIX(S);   // Fixed effect design matrix for p0
  DATA_SPARSE_MATRIX(W);   // Fixed effect design matrix for p1
  PARAMETER(logphi);       // Precision parameter (UG distribution)
  
  // Parametrization
    Type phi = exp(logphi); 
    
  // Distribution of obs given random effects (y|u):
    vector<Type> mu = exp(X*beta)/(1 + exp(X*beta)); 
  
  // Linear predictor for zero inflated
    vector<Type> p0 = exp(S*gamma)/(1 + exp(S*gamma));
    
  // Linear predictor for one inflated
    vector<Type> p1 = exp(W*delta)/(1 + exp(W*delta)); 
  
  // Unit gamma (parameterization)  
    vector<Type> tau = pow(mu, 1/phi)/(1 - pow(mu, 1/phi));
    
  // Log-likelihood
    Type nll1 = 0;
    Type nll2 = 0;
    Type nll3 = 0;
    for(int i=0; i<y.size(); i++)
    
    if (y(i)==0) 
      nll1 -= log(p0(i)); // Zero augmented
        else
         if (y(i)==1) 
           nll2 -= log(p1(i)); // One augmented
          else 
            nll3 -= log((1-p0(i)-p1(i))) + phi*log(tau(i))-1*lgamma(phi)+(tau(i)-1)*log(y(i))+(phi-1)*log(-log(y(i)));

  // Report 
    ADREPORT(phi);

  return nll1 + nll2 + nll3;
}

