## Periodontal Disease (PD) data set ------------------------------------------
## Author: Ricardo Rasmussen Petterle DMI/UFPR --------------------------------
## Date: 09/05/2023 -----------------------------------------------------------

rm(list = ls())

## BEGIN HEADER ----------------------------------------------------------------
## Loading extra packages
library(TMB)
library(gamlss)

## Loading extra functions
source("GOF.R")

## Loading data set
da <- read.table("PD_Data_Set.csv", h = T, sep = ",")

## Preparing data set
da$tooth <- factor(da$tooth)
levels(da$tooth) <- c("Molar", "Premolar", "Canine", "Incisor")

## Gender
da$gender <- factor(da$gender)
levels(da$gender) <- c("Male", "Female")

## HbA1c
da$hba1c <- factor(da$hba1c)
levels(da$hba1c) <- c("Controlled", "Uncontrolled")

## Smoker
da$smoker <- factor(da$smoker)
levels(da$smoker) <- c("Non-smoker", "Smoker")
## END HEADER -----------------------------------------------------------------

## Fitting: GAMLSS (initial values) -------------
## Model1
fit_gamlss <- gamlss(prop ~ gender + age + hba1c + smoker + relevel(tooth, ref = "Canine") + re(random=~1|id), 
                      nu.formula = ~ 1,
                      tau.formula = ~ 1,
                      family = BEINF,
                      data = da)
summary(fit_gamlss)

## Model2 
fit_gamlss1 <- gamlss(prop ~ gender + age + hba1c + smoker + relevel(tooth, ref = "Canine") + re(random=~1|id), 
                      nu.formula = ~ gender + age + hba1c + smoker + relevel(tooth, ref = "Canine"),
                      tau.formula = ~ gender + age + hba1c + smoker + relevel(tooth, ref = "Canine"),
                     family = BEINF,
                     data = da)
summary(fit_gamlss1)

## Model 1: ZOAUG -------------------------------
compile("ZOAUG_Mixed.cpp")
dyn.load(dynlib("ZOAUG_Mixed"))

## Initial values
beta = as.numeric(fit_gamlss$mu.coefficients)[-9]
phi = as.numeric(fit_gamlss$sigma.coefficients)
gamma = as.numeric(fit_gamlss$nu.coefficients)
delta = as.numeric(fit_gamlss$tau.coefficients)

## Data -----------------------------------------
X <- model.matrix(~ gender + age + hba1c + smoker + relevel(tooth, ref = "Canine"), da)
Z <- model.matrix(~ factor(id)-1, da)
S <- model.matrix(~ 1, da)
W <- model.matrix(~ 1, da)
X <- as(X,"dgTMatrix")
Z <- as(Z,"dgTMatrix")
S <- as(S,"dgTMatrix")
W <- as(W,"dgTMatrix")
u <- rnorm(ncol(Z))

## Fit model ------------------------------------
ZOAUG_M1 <- MakeADFun(data=list(y = da$prop, X = X, Z = Z, S = S, W = W),
                   parameters = list(beta = beta, gamma = gamma,
                                     logphi = phi, delta = delta,
                                     logsdu = 1, u = u*0),
                   random = "u",
                   hessian = T,
                   DLL = "ZOAUG_Mixed",
                   silent = F)
## Optimization
opt_zoaug_M1 <- nlminb(ZOAUG_M1$par, ZOAUG_M1$fn, ZOAUG_M1$gr,
                       control = list(eval.max = 1000, iter.max = 1000, 
                                      abs.tol = 1e-04, rel.tol = 1e-04))
temp1 <- sdreport(ZOAUG_M1)
ZOAUG_Result_M1 <- summary(temp1, "fixed", p.value = T)
summary(temp1, "report", p.value = T)

## Goodness-of-fit measures
GOF(model_opt = opt_zoaug_M1, N = 1160)

## Model 1: ZOAB --------------------------------------------------------------
compile("ZOAB_Mixed.cpp")
dyn.load(dynlib("ZOAB_Mixed"))

## Initial values
beta = as.numeric(fit_gamlss$mu.coefficients)[-9]
phi = as.numeric(fit_gamlss$sigma.coefficients)
gamma = as.numeric(fit_gamlss$nu.coefficients)
delta = as.numeric(fit_gamlss$tau.coefficients)

## Data -----------------------------------------
X <- model.matrix(~ gender + age + hba1c + smoker + relevel(tooth, ref = "Canine"), da)
Z <- model.matrix(~ factor(id)-1, da)
S <- model.matrix(~ 1, da)
W <- model.matrix(~ 1, da)
X <- as(X,"dgTMatrix")
Z <- as(Z,"dgTMatrix")
S <- as(S,"dgTMatrix")
W <- as(W,"dgTMatrix")
u <- rnorm(ncol(Z))

## Fit model ------------------------------------
ZOAB_M1 <- MakeADFun(data=list(y = da$prop, X = X, Z = Z, S = S, W = W),
                     parameters = list(beta = beta, gamma = gamma,
                                       logphi = phi, delta = delta,
                                       logsdu = 1, u = u*0),
                     random = "u",
                     hessian = T,
                     DLL = "ZOAB_Mixed",
                     silent = F)
## Optimization
opt_zoab_M1 <- nlminb(ZOAB_M1$par, ZOAB_M1$fn, ZOAB_M1$gr,
                      control = list(eval.max = 1000, iter.max = 1000, 
                                     abs.tol = 1e-04, rel.tol = 1e-04))
temp2 <- sdreport(ZOAB_M1)
ZOAB_Result_M1 <- summary(temp2, "fixed", p.value = T)
summary(temp2, "report", p.value = T)

## Goodness-of-fit measures
GOF(model_opt = opt_zoab_M1, N = 1160)

## Model 2: ZOAUG -------------------------------------------------------------
compile("ZOAUG_Mixed.cpp")
dyn.load(dynlib("ZOAUG_Mixed"))

## Initial values
beta = as.numeric(fit_gamlss1$mu.coefficients)[-9]
phi = as.numeric(fit_gamlss1$sigma.coefficients)
gamma = as.numeric(fit_gamlss1$nu.coefficients)
delta = as.numeric(fit_gamlss1$tau.coefficients)

## Data -----------------------------------------
X <- model.matrix(~ gender + age + hba1c + smoker + relevel(tooth, ref = "Canine"), da)
Z <- model.matrix(~ factor(id)-1, da)
S <- model.matrix(~ gender + age + hba1c + smoker + relevel(tooth, ref = "Canine"), da)
W <- model.matrix(~ gender + age + hba1c + smoker + relevel(tooth, ref = "Canine"), da)
X <- as(X,"dgTMatrix")
Z <- as(Z,"dgTMatrix")
S <- as(S,"dgTMatrix")
W <- as(W,"dgTMatrix")
u <- rnorm(ncol(Z))

## Fit model ------------------------------------
ZOAUG_M2 <- MakeADFun(data=list(y = da$prop, X = X, Z = Z, S = S, W = W),
                  parameters = list(beta = beta, gamma = gamma,
                                    logphi = phi, delta = delta,
                                    logsdu = 1, u = u*0),
                  random = "u",
                  hessian = T,
                  DLL = "ZOAUG_Mixed",
                  silent = F)
## Optimization
opt_zoaug_M2 <- nlminb(ZOAUG_M2$par, ZOAUG_M2$fn, ZOAUG_M2$gr,
                       control = list(eval.max = 1000, iter.max = 1000, 
                                      abs.tol = 1e-04, rel.tol = 1e-04))
opt_zoaug_M2
temp3 <- sdreport(ZOAUG_M2)
ZOAUG_Result_M2 <- summary(temp3, "fixed", p.value = T)
summary(temp3, "report", p.value = T)

## Goodness-of-fit measures
GOF(model_opt = opt_zoaug_M2, N = 1160)

## Model 2: ZOAB --------------------------------------------------------------
compile("ZOAB_Mixed.cpp")
dyn.load(dynlib("ZOAB_Mixed"))

## Initial values
beta = as.numeric(fit_gamlss1$mu.coefficients)[-9]
phi = as.numeric(fit_gamlss1$sigma.coefficients)
gamma = as.numeric(fit_gamlss1$nu.coefficients)
delta = as.numeric(fit_gamlss1$tau.coefficients)

## Data -----------------------------------------
X <- model.matrix(~ gender + age + hba1c + smoker + relevel(tooth, ref = "Canine"), da)
Z <- model.matrix(~ factor(id)-1, da)
S <- model.matrix(~ gender + age + hba1c + smoker + relevel(tooth, ref = "Canine"), da)
W <- model.matrix(~ gender + age + hba1c + smoker + relevel(tooth, ref = "Canine"), da)
X <- as(X,"dgTMatrix")
Z <- as(Z,"dgTMatrix")
S <- as(S,"dgTMatrix")
W <- as(W,"dgTMatrix")
u <- rnorm(ncol(Z))

## Fit model ------------------------------------
ZOAB_M2 <- MakeADFun(data=list(y = da$prop, X = X, Z = Z, S = S, W = W),
                     parameters = list(beta = beta, gamma = gamma,
                                       logphi = phi, delta = delta,
                                       logsdu = 1, u = u*0),
                     random = "u",
                     hessian = T,
                     DLL = "ZOAB_Mixed",
                     silent = F)
## Optimization
opt_zoab_M2 <- nlminb(ZOAB_M2$par, ZOAB_M2$fn, ZOAB_M2$gr,
                      control = list(eval.max = 1000, iter.max = 1000, 
                                     abs.tol = 1e-04, rel.tol = 1e-04))
opt_zoab_M2
temp4 <- sdreport(ZOAB_M2)
ZOAB_Result_M2 <- summary(temp4, "fixed", p.value = T)
summary(temp4, "report", p.value = T)

## Goodness-of-fit measures
GOF(model_opt = opt_zoab_M2, N = 1160)

# END -------------------------------------------------------------------------