// Fitting MGLMM Beta 
#include <TMB.hpp>
template<class Type>
Type objective_function<Type>::operator() ()
{
  using namespace density;
  DATA_VECTOR(Y1);
  DATA_VECTOR(Y2);
  DATA_VECTOR(Y3);
  DATA_MATRIX(X);
  DATA_SPARSE_MATRIX(S1);   // Fixed effect design matrix for p01
  DATA_SPARSE_MATRIX(S2);   // Fixed effect design matrix for p02
  DATA_SPARSE_MATRIX(S3);   // Fixed effect design matrix for p03
  DATA_SPARSE_MATRIX(W1);   // Fixed effect design matrix for p11
  DATA_SPARSE_MATRIX(W2);   // Fixed effect design matrix for p12
  DATA_SPARSE_MATRIX(W3);   // Fixed effect design matrix for p12
  // Parameters -----------------------------------------------------
  PARAMETER_VECTOR(beta1);
  PARAMETER_VECTOR(beta2);
  PARAMETER_VECTOR(beta3);
  PARAMETER_MATRIX(U);
  PARAMETER_VECTOR(rho);
  PARAMETER_VECTOR(sigma);
  PARAMETER_VECTOR(phi);
  PARAMETER_VECTOR(gamma1); // Fixed effects vector for p01
  PARAMETER_VECTOR(gamma2); // Fixed effects vector for p02
  PARAMETER_VECTOR(gamma3); // Fixed effects vector for p03
  PARAMETER_VECTOR(delta1); // Fixed effects vector for p11
  PARAMETER_VECTOR(delta2); // Fixed effects vector for p12
  PARAMETER_VECTOR(delta3); // Fixed effects vector for p13
  // ----------------------------------------------------------------
  // Preparing
  vector<Type> rho_temp(3);
  rho_temp = rho;
  
  vector<Type> sigma_temp(3);
  sigma_temp = sigma;
  
  vector<Type> mu1(Y1.size());
  vector<Type> mu2(Y2.size());
  vector<Type> mu3(Y3.size());
  vector<Type> phi_temp(3);
  phi_temp = phi;
  
  // Configuration for UG density
  vector<Type> tau1(Y1.size());
  vector<Type> tau2(Y2.size());
  vector<Type> tau3(Y3.size());
  
  // Linear predictor for mean model
  mu1 = exp(X*beta1 + U.col(0).array())/(1 + exp(X*beta1 + U.col(0).array()));
  mu2 = exp(X*beta2 + U.col(1).array())/(1 + exp(X*beta2 + U.col(1).array()));
  mu3 = exp(X*beta3 + U.col(2).array())/(1 + exp(X*beta3 + U.col(2).array())); 
  
  // Linear predictor for zero inflated
  vector<Type> p01 = exp(S1*gamma1)/(1 + exp(S1*gamma1));
  vector<Type> p02 = exp(S2*gamma2)/(1 + exp(S2*gamma2));
  vector<Type> p03 = exp(S3*gamma3)/(1 + exp(S3*gamma3));
  
  // Linear predictor for one inflated
  vector<Type> p11 = exp(W1*delta1)/(1 + exp(W1*delta1));
  vector<Type> p12 = exp(W2*delta2)/(1 + exp(W2*delta2));
  vector<Type> p13 = exp(W3*delta3)/(1 + exp(W3*delta3));
  
  // Unit gamma parametrization
  tau1 = pow(mu1, 1/exp(phi(0)))/(1 - pow(mu1, 1/exp(phi(0))));
  tau2 = pow(mu2, 1/exp(phi(1)))/(1 - pow(mu2, 1/exp(phi(1))));
  tau3 = pow(mu3, 1/exp(phi(2)))/(1 - pow(mu3, 1/exp(phi(2))));
  
  // Full log-likelihood  
  Type nll1 = 0;
  Type nll2 = 0;
  Type nll3 = 0;
  for(int i=0; i<Y1.size(); i++)
     if (Y1(i)==0) nll1 -= log(p01(i)); // Zero augmented
      else
        if (Y1(i)==1) nll2 -= log(p11(i)); // One augmented
          else nll3 -= log((1 - p01(i) - p11(i))) + exp(phi(0))*log(tau1(i))-1*lgamma(exp(phi(0)))+(tau1(i)-1)*log(Y1(i))+(exp(phi(0))-1)*log(-log(Y1(i)));
  Type nll4 = 0;
  Type nll5 = 0;
  Type nll6 = 0;
  for(int i=0; i<Y2.size(); i++)
     if (Y2(i)==0) nll4 -= log(p02(i)); // Zero augmented
      else
        if (Y2(i)==1) nll5 -= log(p12(i)); // One augmented
          else nll6 -= log((1 - p02(i) - p12(i))) + exp(phi(1))*log(tau2(i))-1*lgamma(exp(phi(1)))+(tau2(i)-1)*log(Y2(i))+(exp(phi(1))-1)*log(-log(Y2(i)));
  Type nll7 = 0;
  Type nll8 = 0;
  Type nll9 = 0;
  for(int i=0; i<Y3.size(); i++)
     if (Y3(i)==0) nll7 -= log(p03(i)); // Zero augmented
      else
        if (Y3(i)==1) nll8 -= log(p13(i)); // One augmented
          else nll9 -= log((1 - p03(i) - p13(i))) + exp(phi(2))*log(tau3(i))-1*lgamma(exp(phi(2)))+(tau3(i)-1)*log(Y3(i))+(exp(phi(2))-1)*log(-log(Y3(i)));
  
  Type nll = 0;
  for(int i = 0; i < Y1.size(); i++)
   nll += VECSCALE(UNSTRUCTURED_CORR(rho_temp), sigma_temp)(U.row(i));
 
  matrix<Type> Cor(3,3);
  Cor = UNSTRUCTURED_CORR(rho_temp).cov();
  REPORT(Cor);
  REPORT(sigma_temp);
  REPORT(exp(phi));
  ADREPORT(phi);
  ADREPORT(sigma);
  return nll1 + nll2 + nll3 + nll4 + nll5 + nll6 + nll7 + nll8 + nll9 + nll;
}
