## Hungary data set: Data analysis ------------------------------------
## Author: Ricardo Rasmussen Petterle DMI/UFPR ------------------------
## Date: May, 22 2023 -------------------------------------------------

rm(list = ls())

## Loading extra packages
library(R2MLwiN)
library(Matrix)
library(mcglm)
library(TMB)
library(gamlss)

## Loading extra function
source("GOF.R")

## Loading data sets
data(hungary1, package = "R2MLwiN")
da <- hungary1

## Response variables
da$y1 <- da$biol_core/10
da$y2 <- da$phys_core/10
da$y3 <- da$es_core/10

## Preparing data set
da <- da[,c(1,2,10:13)]

## Fitting: GAMLSS (initial values) -------------------------------------------
## Response 1
fit_gamlss1 <- gamlss(y1 ~ female + re(random=~1|school), 
                     nu.formula = ~ 1,
                     tau.formula = ~ female,
                     family = BEINF,
                     data = da)

## Response 2
fit_gamlss2 <- gamlss(y2 ~ female + re(random=~1|school), 
                      nu.formula = ~ 1,
                      tau.formula = ~ female,
                      family = BEINF,
                      data = da)

## Response 3
fit_gamlss3 <- gamlss(y3 ~ female + re(random=~1|school), 
                      nu.formula = ~ 1,
                      tau.formula = ~ female,
                      family = BEINF,
                      data = da)

## ----------------------------------------------------------------------------
## -------------------- Univariate models -------------------------------------
## ----------------------------------------------------------------------------
compile("Univariate_ZOAUG.cpp")
dyn.load(dynlib("Univariate_ZOAUG"))

## Response 1 -----------------------------------

## Initial values from gamlss univariate model
beta1 = as.numeric(fit_gamlss1$mu.coefficients)[-3]

## Precision
phi1 = as.numeric(fit_gamlss1$sigma.coefficients)

## Zero augmented
gamma1 = as.numeric(fit_gamlss1$nu.coefficients)

## One augmented
delta1 = as.numeric(fit_gamlss1$tau.coefficients)

## Initial values
parameters <- list(beta = beta1, 
                   logphi = phi1, 
                   gamma = gamma1,
                   delta = delta1)

## Data 
Y1 <- da$y1
X <- model.matrix(~ female, da)
S <- model.matrix(~ 1, da)
W <- model.matrix(~ female, da)
X <- as(X,"dgTMatrix")
S <- as(S,"dgTMatrix")
W <- as(W,"dgTMatrix")

data <- list(y = Y1, X = X, 
             S = S, W = W)

## Log-likelihood function
obj <- MakeADFun(data, parameters, DLL = "Univariate_ZOAUG", 
                 hessian = TRUE, 
                 silent = FALSE)
obj$fn()
obj$gr()
## Fitting --------------------------------------------------------------------
system.time(fit_UZOAUG_Y1 <- nlminb(start = obj$par, objective = obj$fn, gradient = obj$gr,
                                    control = list(eval.max = 1000, iter.max = 1000, 
                                                   abs.tol = 1e-04, rel.tol = 1e-04)))
fit_UZOAUG_Y1
rep <- sdreport(obj)
UZOAUG_Y1_result <- summary(rep, "fixed", p.value = T)
UZOAUG_Y1_result

## Report
UZOAUG_Y1_report <- summary(rep, "report")
UZOAUG_Y1_report

## Response 2 -----------------------------------

## Initial values from gamlss univariate model
beta2 = as.numeric(fit_gamlss2$mu.coefficients)[-3]

## Precision
phi2 = as.numeric(fit_gamlss2$sigma.coefficients)

## Zero augmented
gamma2 = as.numeric(fit_gamlss2$nu.coefficients)

## One augmented
delta2 = as.numeric(fit_gamlss2$tau.coefficients)

## Initial values
parameters <- list(beta = beta2, 
                   logphi = phi2, 
                   gamma = gamma2,
                   delta = delta2)

## Data 
Y2 <- da$y2
X <- model.matrix(~ female, da)
S <- model.matrix(~ 1, da)
W <- model.matrix(~ female, da)
X <- as(X,"dgTMatrix")
S <- as(S,"dgTMatrix")
W <- as(W,"dgTMatrix")

data <- list(y = Y2, X = X, 
             S = S, W = W)

## Log-likelihood function
obj <- MakeADFun(data, parameters, DLL = "Univariate_ZOAUG", 
                 hessian = TRUE, 
                 silent = FALSE)
obj$fn()
obj$gr()
## Fitting --------------------------------------------------------------------
system.time(fit_UZOAUG_Y2 <- nlminb(start = obj$par, objective = obj$fn, gradient = obj$gr,
                                    control = list(eval.max = 1000, iter.max = 1000, 
                                                   abs.tol = 1e-04, rel.tol = 1e-04)))
fit_UZOAUG_Y2
rep <- sdreport(obj)
UZOAUG_Y2_result <- summary(rep, "fixed", p.value = T)
UZOAUG_Y2_result

## Report
UZOAUG_Y2_report <- summary(rep, "report")
UZOAUG_Y2_report

## Response 3 -----------------------------------

## Initial values from gamlss univariate model
beta3 = as.numeric(fit_gamlss3$mu.coefficients)[-3]

## Precision
phi3 = as.numeric(fit_gamlss3$sigma.coefficients)

## Zero augmented
gamma3 = as.numeric(fit_gamlss3$nu.coefficients)

## One augmented
delta3 = as.numeric(fit_gamlss3$tau.coefficients)

## Initial values
parameters <- list(beta = beta3, 
                   logphi = phi3, 
                   gamma = gamma3,
                   delta = delta3)

## Data 
Y3 <- da$y3
X <- model.matrix(~ female, da)
S <- model.matrix(~ 1, da)
W <- model.matrix(~ female, da)
X <- as(X,"dgTMatrix")
S <- as(S,"dgTMatrix")
W <- as(W,"dgTMatrix")

data <- list(y = Y3, X = X, 
             S = S, W = W)

## Log-likelihood function
obj <- MakeADFun(data, parameters, DLL = "Univariate_ZOAUG", 
                 hessian = TRUE, 
                 silent = FALSE)
obj$fn()
obj$gr()
## Fitting --------------------------------------------------------------------
system.time(fit_UZOAUG_Y3 <- nlminb(start = obj$par, objective = obj$fn, gradient = obj$gr,
                                    control = list(eval.max = 1000, iter.max = 1000, 
                                                   abs.tol = 1e-04, rel.tol = 1e-04)))
fit_UZOAUG_Y3
rep <- sdreport(obj)
UZOAUG_Y3_result <- summary(rep, "fixed", p.value = T)
UZOAUG_Y3_result

## Report
UZOAUG_Y3_report <- summary(rep, "report")
UZOAUG_Y3_report

## Multivariate augmented unit-gamma regression model -------------------------
compile("Multivariate_ZOAUG.cpp")
dyn.load(dynlib("Multivariate_ZOAUG"))

## Initial values from gamlss univariate model
beta1 = as.numeric(fit_gamlss1$mu.coefficients)[-3]
beta2 = as.numeric(fit_gamlss2$mu.coefficients)[-3]
beta3 = as.numeric(fit_gamlss3$mu.coefficients)[-3]

## Precision
phi1 = as.numeric(fit_gamlss1$sigma.coefficients)
phi2 = as.numeric(fit_gamlss2$sigma.coefficients)
phi3 = as.numeric(fit_gamlss3$sigma.coefficients)

## Zero augmented
gamma1 = as.numeric(fit_gamlss1$nu.coefficients)
gamma2 = as.numeric(fit_gamlss2$nu.coefficients)
gamma3 = as.numeric(fit_gamlss3$nu.coefficients)

## One augmented
delta1 = as.numeric(fit_gamlss1$tau.coefficients)
delta2 = as.numeric(fit_gamlss2$tau.coefficients)
delta3 = as.numeric(fit_gamlss3$tau.coefficients)

## Initial values
parameters <- list(beta1 = beta1, beta2 = beta2, beta3 = beta3, 
                   phi = c(phi1, phi2, phi3), 
                   gamma1 = gamma1, gamma2 = gamma2, gamma3 = gamma3, 
                   delta1 = delta1, delta2 = delta2, delta3 = delta3,
                   U = matrix(0, ncol = 3, nrow = 2439), 
                   rho = c(0, 0, 0), 
                   sigma = c(0.11, 0.11, 0.11))
## Data 
Y1 <- da$y1
Y2 <- da$y2
Y3 <- da$y3
X <- model.matrix(~ female, da)
S1 <- model.matrix(~ 1, da)
W1 <- model.matrix(~ female, da)
S2 <- model.matrix(~ 1, da)
W2 <- model.matrix(~ female, da)
S3 <- model.matrix(~ 1, da)
W3 <- model.matrix(~ female, da)
S1 <- as(S1,"dgTMatrix")
W1 <- as(W1,"dgTMatrix")
S2 <- as(S2,"dgTMatrix")
W2 <- as(W2,"dgTMatrix")
S3 <- as(S3,"dgTMatrix")
W3 <- as(W3,"dgTMatrix")

data <- list(Y1 = Y1, Y2 = Y2, Y3 = Y3, X = X, S1 = S1,
             S2 = S2, S3 = S3, W1 = W1, W2 = W2, W3 = W3)

## Log-likelihood function
obj <- MakeADFun(data, parameters, DLL = "Multivariate_ZOAUG", 
                 random = "U", 
                 hessian = TRUE, 
                 silent = FALSE)
obj$fn()
obj$gr()
## Fitting --------------------------------------------------------------------
system.time(fit_MZOAUG <- nlminb(start = obj$par, objective = obj$fn, gradient = obj$gr,
                                    control = list(eval.max = 1000, iter.max = 1000, 
                                                   abs.tol = 1e-04, rel.tol = 1e-04)))
fit_MZOAUG
rep <- sdreport(obj)
MZOAUG_result <- summary(rep, "fixed", p.value = T)

## Report
MZOAUG_rep <- summary(rep, "report")
MZOAUG_rep

MZOAUG_report <- obj$report()

## Correlation matrix
MZOAUG_report$Cor

## Coefficients ---------------------------------------------------------------
## Univariate -----------------------------------
## Response 1
betas_Y1 <- fit_UZOAUG_Y1$par
betas_Y1 <- betas_Y1[c(1,2)]
gamma_Y1 <- fit_UZOAUG_Y1$par[3]
deltas_Y1 <- fit_UZOAUG_Y1$par[c(4,5)]

## Response 2
betas_Y2 <- fit_UZOAUG_Y2$par
betas_Y2 <- betas_Y2[c(1,2)]
gamma_Y2 <- fit_UZOAUG_Y2$par[3]
deltas_Y2 <- fit_UZOAUG_Y2$par[c(4,5)]

## Response 3
betas_Y3 <- fit_UZOAUG_Y3$par
betas_Y3 <- betas_Y3[c(1,2)]
gamma_Y3 <- fit_UZOAUG_Y3$par[3]
deltas_Y3 <- fit_UZOAUG_Y3$par[c(4,5)]

## Full betas
full_betas <- c(betas_Y1, betas_Y2, betas_Y3)

## Full gammas 
full_gammas <- c(gamma_Y1, gamma_Y2, gamma_Y3)

## Full deltas
full_deltas <- c(deltas_Y1, deltas_Y2, deltas_Y3)

## Full coefficients
full_coefs_uni <- c(full_betas, full_gammas, full_deltas)

## Multivariate ---------------------------------
full_coefs_mult <- fit_MZOAUG$par[-c(7:15)]

## Standard deviation ---------------------------------------------------------
## Univariate -----------------------------------
## Response 1
betas_SD_Y1 <- UZOAUG_Y1_result[c(1,2),2]
gamma_SD_Y1 <- UZOAUG_Y1_result[3,2]
deltas_SD_Y1 <- UZOAUG_Y1_result[c(4, 5),2]

## Response 2
betas_SD_Y2 <- UZOAUG_Y2_result[c(1,2),2]
gamma_SD_Y2 <- UZOAUG_Y2_result[3,2]
deltas_SD_Y2 <- UZOAUG_Y2_result[c(4,5),2]

## Response 3
betas_SD_Y3 <- UZOAUG_Y3_result[c(1,2),2]
gamma_SD_Y3 <- UZOAUG_Y3_result[3,2]
deltas_SD_Y3 <- UZOAUG_Y3_result[c(4,5),2]

## Full betas
full_betas_SD <- c(betas_SD_Y1, betas_SD_Y2, betas_SD_Y3)

## Full gammas 
full_gammas_SD <- c(gamma_SD_Y1, gamma_SD_Y2, gamma_SD_Y3)

## Full deltas
full_deltas_SD <- c(deltas_SD_Y1, deltas_SD_Y2, deltas_SD_Y3)

## Full standard deviation
full_SD_uni <- c(full_betas_SD, full_gammas_SD, full_deltas_SD)

## Multivariate ---------------------------------
full_SD_mult <- MZOAUG_result[-c(7:15),2]

## Coefficients and SD for uni and multivariate models ------------------------

## Final table
final_tab <- cbind(full_coefs_uni, full_SD_uni, 
                   full_coefs_mult, full_SD_mult)
colnames(final_tab) <- c("Estimates", "SD", "Estimates", "SD")
final_tab
## END ------------------------------------------------------------------------