# Multivariate augmented unit-gamma mixed regression models -------------------
# Author: Ricardo Rasmussen Petterle/UFPR -------------------------------------
# Date: 29/06/2023 ------------------------------------------------------------

# Function to calculate goodness-of-fit measures 
GOF <- function(model_opt, N){
  k = length(model_opt$par)
  LL = -1*model_opt$objective
  AIC = 2*k -2*LL
  BIC = k*log(N) -2*LL
  out = data.frame("LogLik" = LL,
                   "AIC" = AIC,
                   "BIC" = BIC)
  return(out)
}
# END -------------------------------------------------------------------------
