// Beta Zero Inflated mixed model with fixed precision
#include <TMB.hpp>

template<class Type>
Type objective_function<Type>::operator() ()
{
  DATA_VECTOR(y);         // Observations
  DATA_SPARSE_MATRIX(X);  // Fixed effect design matrix
  PARAMETER_VECTOR(beta); // Fixed effects vector for mu
  PARAMETER_VECTOR(gamma); // Fixed effects vector for nu
  DATA_SPARSE_MATRIX(Z);  // Random effect design matrix
  DATA_SPARSE_MATRIX(S);  // Fixed effect design matrix for nu
  PARAMETER_VECTOR(u);    // Random effects vector
  PARAMETER(logsdu);      // Random effect standard deviations
  PARAMETER(logphi);      // Precision parameter (Beta)
  Type phi = exp(logphi); 
  Type sdu = exp(logsdu);

  // Distribution of random effect (u):
  Type nll2 = 0;
  nll2 -= dnorm(u, Type(0), sdu, true).sum();
  
  // Distribution of obs given random effects (y|u):
    vector<Type> mu = exp(X*beta + Z*u)/(1 + exp(X*beta + Z*u)); 
  
  // Linear predictor for zero inflated
    vector<Type> nu = exp(S*gamma)/(1 + exp(S*gamma)); 
    
    // Shape A (Beta)
    vector<Type> shapeA(y.size());
    shapeA = mu*phi;
    
    // Shape B (Beta)
    vector<Type> shapeB(y.size());
    shapeB = (1-mu)*phi;
    
    // Log-likelihood
    Type nll1 = 0;
    for(int i=0; i<y.size(); i++)
    
    if (y(i)==0) nll1 -= log(nu(i));
            else nll2 -= log(1 - nu(i)) + dbeta(y(i), shapeA(i), shapeB(i), true);

    // Report 
    ADREPORT(sdu);
    ADREPORT(phi);

  return nll1 + nll2;
}

