// Unit gamma mixed model with varying precision
#include <TMB.hpp>

template<class Type>
Type objective_function<Type>::operator() ()
{
  DATA_VECTOR(y);         // Observations
  DATA_SPARSE_MATRIX(X);  // Fixed effect design matrix (mean)
  PARAMETER_VECTOR(beta); // Fixed effects vector (mean)
  DATA_SPARSE_MATRIX(Z);  // Fixed effect design matrix (precision)
  PARAMETER_VECTOR(gamma); // Fixed effects vector (precision)
  DATA_SPARSE_MATRIX(W);  // Random effect design matrix (mean)
  DATA_SPARSE_MATRIX(S);  // Random effect design matrix (precision)
  PARAMETER_VECTOR(u1);   // Random effects vector (mean)
  PARAMETER_VECTOR(u2);   // Random effects vector (precision)
  PARAMETER(logsdu1);     // Random effect standard deviations (mean)
  PARAMETER(logsdu2);     // Random effect standard deviations (precision)
  
  // Parametrization
  Type sdu1 = exp(logsdu1); 
  Type sdu2 = exp(logsdu2);
  
  // Distribution of random effect (u1): (mean)
  Type nll = 0;
  nll -= dnorm(u1, Type(0), sdu1, true).sum();

  // Distribution of random effect (u2): (precision)
  //Type ans = 0;
  nll -= dnorm(u2, Type(0), sdu2, true).sum();
  
  // Distribution of obs given random effects (y|u):
  vector<Type> mu = exp(X * beta + W * u1)/(1 + exp(X * beta + W * u1));
  vector<Type> phi = exp(Z * gamma + S * u2); 
  vector<Type> tau = pow(mu, 1/phi)/(1 - pow(mu, 1/phi));
    
  // Log-likelihood
    for(int i=0; i<y.size(); i++)
      nll -= phi(i)*log(tau(i))-1*lgamma(phi(i))+(tau(i)-1)*log(y(i))+(phi(i)-1)*log(-log(y(i)));

  // Report 
  ADREPORT(sdu1);
  ADREPORT(sdu2);
 
  return nll;
}

