// Unit gamma nested model 
#include <TMB.hpp>

template<class Type>
Type objective_function<Type>::operator() ()
{
  DATA_VECTOR(y);         // Observations
  DATA_SPARSE_MATRIX(X);  // Fixed effect design matrix
  PARAMETER_VECTOR(beta); // Fixed effects vector
  DATA_SPARSE_MATRIX(Z);  // Random effect design matrix (ui)
  DATA_SPARSE_MATRIX(W);  // Random effect design matrix (uij)
  PARAMETER_VECTOR(ui);   // Random effects vector
  PARAMETER_VECTOR(uij);  // Random effects vector
  PARAMETER(logtau1);     // Random effect standard deviations (ui)
  PARAMETER(logtau2);     // Random effect standard deviations (uij)
  PARAMETER(logphi);      // Precision parameter (Unit gamma)
  
  // Parametrization
  Type tau1 = exp(logtau1); 
  Type tau2 = exp(logtau2); 
  Type phi = exp(logphi); 
  
  // Distribution of random effect (u):
  Type nll = 0;
  nll -= sum(dnorm(ui, Type(0), tau1, true)) + sum(dnorm(uij, Type(0), tau2, true)); 
  
  // Distribution of obs given random effects (y|u):
  vector<Type> mu = exp(X * beta + Z * ui + W * uij)/(1 + exp(X * beta + Z * ui + W * uij));
  vector<Type> tau = pow(mu, 1/phi)/(1 - pow(mu, 1/phi));
    
  // Log-likelihood  
    for(int i=0; i<y.size(); i++)
      nll -= phi*log(tau(i))-1*lgamma(phi)+(tau(i)-1)*log(y(i))+(phi-1)*log(-log(y(i)));

  // Report 
  ADREPORT(phi);
  ADREPORT(tau1);
  ADREPORT(tau2);
 
  return nll;
}

