// Beta mixed model with fixed precision
#include <TMB.hpp>

template<class Type>
Type objective_function<Type>::operator() ()
{
  DATA_VECTOR(y);         // Observations
  DATA_SPARSE_MATRIX(X);  // Fixed effect design matrix
  PARAMETER_VECTOR(beta); // Fixed effects vector
  DATA_SPARSE_MATRIX(Z);  // Random effect design matrix
  PARAMETER_VECTOR(u);    // Random effects vector
  PARAMETER(logsdu);      // Random effect standard deviations
  PARAMETER(logphi);      // Precision parameter (Beta)

  // Parametrization
  Type sdu = exp(logsdu); 
  Type phi = exp(logphi); 
  
  // Distribution of random effect (u):
  Type nll = 0;
  nll -= dnorm(u, Type(0), sdu, true).sum();

  // Distribution of obs given random effects (y|u):
    vector<Type> mu = exp(X * beta + Z * u)/(1 + exp(X * beta + Z * u)); 
  
  // Log-likelihood
    for(int i=0; i<y.size(); i++)
    nll -= dbeta(y(i), mu(i)*phi, (1 - mu(i))*phi, true);

  // Report 
  ADREPORT(sdu);
  ADREPORT(phi);
 
  return nll;
}

