%This function calculates the initial values for estimating the parameters within the two generated terminal nodes
%The idea is to vary the smoothness parameter and try to find the optimal location parameter within the range of the data

function val_inicio = val_inicio_star1(MF,Regressor,d0,X,y,ylag,no,alpha,beta,nval)
decision=[];Teta=[];Beta=[];Xs=X(:,d0);

g=[0.5 1 2.5 5 7.5 10 25 50 75 100 250 500 750 1000];
c=prctile(Xs,[5:5:95]);
loglike=[];
paramest=[];

for i=1:length(g);
    for j=1:length(c)
        T = length(y);
        s=std(X(:,d0));
             result= [tree_loglike_star1(g(i),c(j),alpha,beta,X,y,ylag,MF,no,d0,Regressor)];
             loglike=[loglike;result];
             paramest=[paramest;g(i) c(j) result(2:5)];       
          
         end
end        

%Vector with the log-likelihoods    
log_like_vec = loglike(:,1);
[ind1,ind2]=sort(log_like_vec);

%Select a set of initial values
select=[ind2(1:nval)];

%This program will save the five best results
%if std(paramest(select,2))/mean(paramest(select,2))<0.1
%val_inicio = [paramest(ind2(1),:)];
%else
val_inicio = [paramest(select,:)];
%end

