%This program intends to predict the values of 
% a fitted Tree-STAR model to data

function [yhat,ymember,M,yobs,ylag] = tree_pred_star1(xtest,X,y,Tree)
T=size(X,1);

indbegin=max(find(isnan(X(:,12))==1))+1;

if isempty(indbegin)==1;indbegin=1;end;

y=y(indbegin:T);X=X([indbegin:T],:);ylag=X(:,1);xtest=xtest([indbegin:T],:);

Regressor=Tree.regressor;
Transicao=Tree.var;
Suave=Tree.smooth;
Locacao=Tree.cut;
T=size(xtest,1);

MF=ones(size(xtest,1),1);
Term_node=find(Regressor==1);
a=Tree.class(Term_node)';
b=Tree.class1(Term_node)';

for i=1:max(Term_node)
    
    if Regressor(i)==0
        d=Transicao(i);
        g=Suave(i);
        c=Locacao(i);
        w=(xtest(:,d)-c);
        F=exp(-g.*w)./(1+exp(-g.*w));
        F_=1-F;
        
        MF(:,2*i)=MF(:,i).*F;
        MF(:,2*i+1)=MF(:,i).*F_;
    elseif Regressor(i)==-1
        MF(:,2*i)=MF(:,i).*ones(T,1);
        MF(:,2*i+1)=MF(:,i).*ones(T,1);
    end
    
    
end

%Membership Function
Z=MF(:,Term_node);
Z1=MF(:,Term_node);Z2=reshape(Z,size(Z,1)*size(Z,2),1).*repmat(ylag,size(Z,2),1);Z2=reshape(Z2,size(Z,1),size(Z,2));

%Predicted Values for the STAR-Tree Model
yhat=(a*Z1')'+(b*Z2')';
maxZ=max(Z')';

%Maximum Index for Each Line
indmax=[];for i=1:size(Z,1);mx=find(Z(i,:)==maxZ(i));indmax=[indmax;mx(1)];end; 


for i=1:length(indmax)
    ymember(i)=a(indmax(i))+b(indmax(i))*ylag(i);
end

M=Z;
yobs=y;