function [f,g,H] = tree_loglike_all_star1(x,alpha,beta,X,y,ylag,MF,no,d0,Regressor)
T = length(y);
Regressor([no 2*no 2*no+1])=[1 0 0];
Term_node=find(Regressor==1);
 
W=MF;
W1=reshape(W,size(W,1)*size(W,2),1);
W2=reshape(W,size(W,1)*size(W,2),1).*repmat(ylag,size(W,2),1);

W1=reshape(W1,size(W));
W2=reshape(W2,size(W));

I1=find(Term_node~=no);
I2=setdiff(Term_node,[no 2*no 2*no+1]);


w=(X(:,d0)-x(2));
F=(exp(-x(1)*w))./(1+exp(-x(1)*w));
F_=ones(size(F))-F;
MF(:,2*no)=MF(:,no).*F;MF(:,2*no+1)=MF(:,no).*F_;
Z1=MF(:,2*no);Z2=MF(:,2*no+1);
M=[Z1 Z2 Z1.*ylag Z2.*ylag];
G1=MF(:,2*no);G2=MF(:,2*no+1);

W1(:,2*no)= Z1; W1(:,2*no+1)=Z2;
W2(:,2*no)= Z1.*ylag; W2(:,2*no+1)=Z2.*ylag;

% This step keep fixed the information in the nodes which the parameters had been previously estimated
if no==1
    y_hat=[x(3) x(4) x(5) x(6)]*M';
    erro=y-y_hat';
else
    y_fix = (alpha(I2)*W1(:,I2)')'+(beta(I2)*W2(:,I2)')';
    y_hat=[x(3) x(4) x(5) x(6)]*M';
    erro=(y-y_fix)-y_hat';
 end
 
sigma=std(erro);
 veross=-(T/2)*log(2*pi)-T*log(sigma)-sum(erro.^2)/(2*sigma.^2);

 
f=[-veross];
t1=x(4)-x(3);t2=x(6)-x(5);
dg=-(t1)*inv(sigma^2)*erro.*dg_logist_star1(X(:,d0),x(1),x(2)).*MF(:,no)-(t2)*inv(sigma^2)*ylag.*erro.*dg_logist_star1(X(:,d0),x(1),x(2)).*MF(:,no);
dc=-(t1)*inv(sigma^2)*erro.*dg_logist_star1(X(:,d0),x(1),x(2)).*MF(:,no)-(t2)*inv(sigma^2)*ylag.*erro.*dc_logist_star1(X(:,d0),x(1),x(2)).*MF(:,no);
da1=-inv(sigma^2)*erro.*(-Z1);
da2=-inv(sigma^2)*erro.*(-Z2);
db1=-inv(sigma^2)*erro.*(-Z1).*ylag;
db2=-inv(sigma^2)*erro.*(-Z2).*ylag;

grad=-[dg dc da1 da2 db1 db2]';
%hess=inv(gra'*gra)
g=-[sum(dg) sum(dc) sum(da1) sum(da2) sum(db1) sum(db2)];
H=grad*grad';
%pause(3)
