function [g,c,a,b,mf,mb,min_condition] = tree_estimation_cte(X,y,ylag,MF,no,Regressor,d0,alpha,beta,correct)           
%This function estimates the parameters in each split

warning off      
Regressor([no 2*no 2*no+1])=[0 1 1];

%Initial values for all parameters (nval is the number of initial sets to
%be tried)
nval=3;
Param0=val_inicio_star1(MF,Regressor,d0,X,y,ylag,no,alpha,beta,nval);

%Some definitions for the optimization routines
options=optimset; maxeval=10000;  
options=optimset;  options.Display='off';  options.MaxfunEvals=maxeval;  optios.Maxiter=maxeval;
options.GradObj='on';options.LevenbergMarquardt='on';options.DerivativeCheck='on';option.LargeScale='on';options.Hessian='on';
           

Param=[];FVAL=[];Hessian=[];

for i=1:size(Param0,1)
      param0=Param0(i,:);
      
      g=param0(1);c=param0(2);
      alpha(2*no)=param0(3); alpha(2*no+1)=param0(4);
      beta(2*no)=param0(5);  beta(2*no+1)=param0(6);
            
[param,fval,exitflag,output,grad,hessian] =fminunc('tree_loglike_all_star1',param0,options,alpha,beta,X,y,ylag,MF,no,d0,Regressor);
   
    Hessian=[Hessian reshape(hessian,36,1)];
    Param=[Param; param];
    FVAL=[FVAL;fval];
end

%Selection of the best result
[ind1,ind2]=sort(FVAL);

%Hessian matrix 
hessian=reshape(Hessian(:,ind2(1)),6,6);
Imatrix=inv(hessian);

%Standard Error of Estimates
stderr=sqrt(diag(Imatrix));

stderr_g=stderr(1);
stderr_c=stderr(2);

stderr_a1=stderr(3);
stderr_a2=stderr(4);
stderr_b1=stderr(5);
stderr_b2=stderr(6);

param=Param(ind2(1),:);
g=param(1);c=param(2); a=param(3:4); b=param(5:6);

 
    w=(X(:,d0)-c);
    F=(exp(-g*w))./(1+exp(-g*w));F_=ones(size(F))-F;
    MF(:,2*no)=MF(:,no).*F ;MF(:,2*no+1)=MF(:,no).*F_;
    mf=MF;
    mb=F;

tvalor1 = abs(a(1)-a(2))/sqrt(stderr_a1^2+stderr_a2^2);
tvalor2 = abs(a(1)+a(2))/sqrt(stderr_a1^2+stderr_a2^2);
tvalor3 = abs(b(1)-b(2))/sqrt(stderr_b1^2+stderr_b2^2);
tvalor4 = abs(b(1)+b(2))/sqrt(stderr_b1^2+stderr_b2^2);

tvalores=[tvalor1 tvalor2 tvalor3 tvalor4];
a1valor= abs(a(1))/stderr_a1;
a2valor= abs(a(2))/stderr_a2;
b1valor= abs(b(1))/stderr_b1;
b2valor= abs(b(2))/stderr_b2;


% Critical Values
CritVal_1=abs(tinv(0.05/correct,size(X,1)-2));
CritVal_2=(tinv(0.05/correct,size(X,1)-2));

if  max([tvalor1 tvalor2 tvalor3 tvalor4])<CritVal_1 | max([a1valor a2valor b1valor b2valor])<CritVal_1 
    
    min_condition=0;
    
else
    
    min_condition=1;
    
end


