#!/bin/bash

Options=$@
Optnum=$#

NUMBER=$1 ## Primeiro argumento.

_usage() {
    #--------------------------------------------
    # Shows how use.
    cat <<EOF
runTests $Options
$*
        Usage: runTests num basefile

          num         Number of copies of the file.
          basefile    Name of base file.

        Options:
                -h   --help          Show this message

        Example:
         runTests 10 -b sb01-1.Rnw

EOF
}
if [ $# = 0 ]; then _usage; exit 1; fi

TEMP=`getopt -o hnb: --long help,num,basefile: -n 'runTests' -- "$@"`
if [ $? != 0 ] ; then echo "Terminating." >&2 ; exit 1 ; fi

# Note the quotes around `$TEMP': they are essential!
eval set -- "$TEMP"

while true; do
    case "$1" in
        -h | --help )
            _usage
            exit 1
            break
            ;;
        -b | --basefile )
            BF=$2
            shift
            ;;
        -- )
            shift
            break
            ;;
        * )
            break;
            ;;
    esac
done

# echo "$NUMBER"
# echo "$BF"
# echo "`$#`"
# echo "`$@`"

if [ -z "$BF" ]
then
    echo "A basename file must be informed in the parameter -b or --basefile=..."
    exit 1
else
    echo "A file with $NUMBER copies is being created."
    Rscript -e "nprovas <- $NUMBER; arqbase <- '$BF'; source('correRnw.R')"
fi
