##-----------------------------------------------------------------------------

require(xtable)
require(knitr)

## Número de provas.
nprovas <- 6

## Nome do arquivo com exercícios.
arqbase <- "exerc4-1.Rnw"
arqresu <- gsub("-1", "-2", arqbase)

lista <- vector(mode="list", length=nprovas)
rl0 <- readLines(arqbase)
for(i in seq_along(lista)){
    ##-----------------------------------------------------------------------------
    ## Aqui é gerado um arquivo Rnw com várias cópias do mesmo
    ## exercício, cada um com um SEED diferente que é o que permite a
    ## diferença nas provas.
    x <- i
    rl1 <- gsub(pattern="SEED", replacement=x, x=rl0)
    rl2 <- append(rl1, values=rep("%%----------------", 3))
    lista[[i]] <- rl2
    ##-----------------------------------------------------------------------------
}

## Junta as n provas.
rl3 <- do.call(c, lista)

## Escreve em arquivo de texto.
writeLines(text=rl3, arqresu)

## Converte de Rnw para tex.
knit(arqresu, encoding="utf-8")

## replicate(40, dev.off())

##-----------------------------------------------------------------------------
