anos = seq(1945,1954)
qtd  = c(98.2,92.3,80,89.1,83.5,68.9,69.2,67.1,58.3,61.2)

# verificando o comportamento das variáveis
plot(anos,qtd)

# parece que um modelo linear simples explicará bem o comportamento das variáveis

# usando a função 'lm'

reg = lm(qtd ~ ano )

# antes de verificarmos o resultado, vamos checar os pressupostos.
resid = residuals(reg)

shapiro.test(resid)

# tudo ok com a normalidade dos resíduos.
# checando a homocedasticidade.



plot(anos,resid)
abline(h=0)

# a variância parece constante e não tem tendência.
# agora vamos para o resultado.

summary(reg)

media <- function(x) mean(x)

media <- function(x,y){
 ad <-  mean(x)
 ss  <-  sd(x)
 gg <- function(y){
  hh <- median(y)
 }
}

# podemos tirar todas as informações como output. 
# a primeira delas é que beta1 é significativamente diferente de zero, ou seja, há uma relação entre as variáveis em estudo.
# o coeficiente de determinação é r² = 0,8957 ou 89,57\%.
# um gráfico para finalizar a análise.

plot(anos,qtd,xlab='Anos',ylab='Quantidade (milhões)')
curve(coef(reg)[1]+coef(reg)[2]*x,add=T)
mtext(expression(hat(y) == 8463.17 -4.30*x))
mtext(expression(r^2 == 0.8957),line=-2)


