##=============================================================================
## Terça Insana - 07/10/2014
## Ler dados de páginas html - Walmes Zeviani
##
##=============================================================================

##-----------------------------------------------------------------------------
## Arquivos com pouco conteúdo.

## Lista em html.
browseURL("http://www.w3schools.com/html/tryit.asp?filename=tryhtml_lists_unordered")

## Lista em html.
browseURL("http://www.w3schools.com/html/tryit.asp?filename=tryhtml_lists_unordered")

## Tabela com notas dos alunos.
browseURL("http://www.leg.ufpr.br/~walmes/ensino/ce083-2014-02/saba_notas.html")

## Tabela com scripts disponíveis.
browseURL("http://www.leg.ufpr.br/~walmes/ensino/ce083-2014-02/")

## Tabela de um vídeo no youtube.
browseURL("https://www.youtube.com/watch?v=U0xlKuFqCuI&index=14&list=PLBE9407EA64E2C318")

##-----------------------------------------------------------------------------
## Ler a lista.

list.files(pattern="*.html")
system("cat lista.html")

rl <- readLines("lista.html")
rl

cat(rl, sep="\n")

##-----------------------------------------------------------------------------
## Fazer o parse.

require(XML)

## * htmlTreeParse() faz a decodifação do conteúdo.
## * getNodeSet() e xpathApply() para consultar conteúdo.
## * xmlValue() extrai o valor e xmlGetAttr() extrai atributo.

prs <- htmlTreeParse(rl, useInternalNodes=TRUE)
class(prs)

summary(prs)

methods(class="XMLInternalDocument")

x <- getNodeSet(doc=prs, path="//h2", fun=xmlValue); x
x <- getNodeSet(doc=prs, path="//ul", fun=xmlValue); x
x <- getNodeSet(doc=prs, path="//li", fun=xmlValue); x

xpathApply(doc=prs, path="//li", xmlValue)

help(getNodeSet, help_type="html")

##-----------------------------------------------------------------------------
## Ler as tabelas.

rl <- readLines("tabela.html")
prs <- htmlTreeParse(rl, useInternalNodes=TRUE)
summary(prs)

tb <- readHTMLTable(prs, header=FALSE,
                    stringsAsFactors=FALSE,
                    as.data.frame=TRUE)
str(tb)

rl <- readLines("saba_notas.html")
prs <- htmlTreeParse(rl, useInternalNodes=TRUE)
summary(prs)

tb <- readHTMLTable(prs, header=TRUE,
                    stringsAsFactors=FALSE,
                    as.data.frame=TRUE)
str(tb)

##-----------------------------------------------------------------------------
## Ler a tabela com os links de Estatística Computacional I.

rl <- readLines("http://www.leg.ufpr.br/~walmes/ensino/ce083-2014-02/")
prs <- htmlTreeParse(rl, useInternalNodes=TRUE)
summary(prs)

tb <- readHTMLTable(prs, header=TRUE,
                    stringsAsFactors=FALSE,
                    as.data.frame=TRUE)
tb <-
    readHTMLTable("tabela.html",
                  header=TRUE,
                  stringsAsFactors=FALSE,
                  as.data.frame=TRUE)

str(tb)
tb[[1]]

##-----------------------------------------------------------------------------
## Ok! Ok! Mas e quero ter os links para disparar um processo que faça
## download de todas as aulas. Como pegar os links.

pre <- "http://www.leg.ufpr.br/~walmes/ensino/ce083-2014-02/"
paste0(pre, grep(x=tb[[1]][,2], pattern="^ce083", value=TRUE))

## Outra forma é não ler como tabela.

summary(prs)

x <- getNodeSet(doc=prs, path="//td//a", fun=xmlValue); x
## x <- getNodeSet(doc=prs, path="//td//a", fun=xmlGetAttr, "href"); x

## Só os links.
xpathApply(doc=prs, path="//td//a", fun=xmlGetAttr, "href")

##-----------------------------------------------------------------------------
## Ler uma página do youtube.

url <- "http://www.youtube.com/watch?v=U0xlKuFqCuI&index=14&list=PLBE9407EA64E2C318"
browseURL(url)

rl <- readLines(url)
prs <- htmlTreeParse(rl, useInternalNodes=TRUE)
summary(prs)

## O título do vídeo.
x <- getNodeSet(doc=prs, path="//title", fun=xmlValue); x

## O número de views. `<div class="watch-view-count" >16,736</div>`.
x <- getNodeSet(doc=prs, path='//div[@class="watch-view-count"]',
                fun=xmlValue); x

## O número de likes. `<span class="yt-uix-button-content">`
## <span id="watch-like-dislike-buttons"

x <- getNodeSet(doc=prs,
                path='//span[@class="yt-uix-button-content"]',
                fun=xmlValue); x

unlist(x)
grep(x=x, pattern="\\d", value=TRUE)

x <- getNodeSet(doc=prs,
                path='//button[@id="watch-like"]//span[@class="yt-uix-button-content"]',
                fun=xmlValue); x

x <- getNodeSet(doc=prs,
                path='//button[@id="watch-dislike"]//span[@class="yt-uix-button-content"]',
                fun=xmlValue); x

##-----------------------------------------------------------------------------
## Ler dados do imóveis Curitiba.

url <- "http://www.imoveiscuritiba.com.br/apartamentos-venda-curitiba-pr.html"
browseURL(url)

rl <- readLines(url)
prs <- htmlTreeParse(rl, useInternalNodes=TRUE)
summary(prs)

x <- getNodeSet(doc=prs,
                path="//ul[@class='post-content']",
                fun=xmlValue)
x <- unlist(x)
cat(x, sep="\n")


cat(x[-(1:6)], sep="\n")

## Depois disso é manipulação de dados. Deixar para o Cryttian.
do.call(rbind, strsplit(x[-(1:6)], split="\n"))

## Como pegar o valor do preço do imóvel?
y <- getNodeSet(doc=prs,
                path="//div[@class='post-price']",
                fun=xmlValue)
y <- unlist(y)
y[-(1:6)]

##-----------------------------------------------------------------------------
## Ler dados do webmotors.com.

url <-
    "http://www.webmotors.com.br/comprar/carros/novos-usados/veiculos-todos-estados/volkswagen/fox?pagina=1"
browseURL(url)

rl <- readLines(url, encoding="utf-8")
prs <- htmlTreeParse(rl, useInternalNodes=TRUE, encoding="utf-8")
summary(prs)

## Número de carros retornados na busca.
x <- getNodeSet(doc=prs,
                path="//h2[@class='span-13 size-16 frase-resultado']",
                fun=xmlValue)

x <- as.integer(gsub(x=x, pattern="\\D", replacement="")); x
x%/%20+1 ## Número total de páginas a serem consultadas.

## As informações extraidas. Requer lapidação.
x <- getNodeSet(doc=prs,
                path="//div[@class='span-20-b last item-resultado raio-5']",
                fun=xmlValue)
cat(unlist(x))

## Lapidação prévia.
vals <- sapply(x,
               function(x){
                   y <- unlist(strsplit(x, "\n"))
                   y <- c(y[grep("Cor:", y)-1:0],
                          y[grep("Ícone Km", y)+1],
                          y[grep("Ícone Ano", y)+1],
                          y[grep("Ícone Preço", y)+1]
                          )
                   gsub("^\\s*", "", y)
               })
dim(vals)

x <- getNodeSet(doc=prs,
                path="//div[@class='span-2-b div-ano']//p[@class='size-12-bold ano-texto']",
                fun=xmlValue)

x <- getNodeSet(doc=prs,
                path="//div[@class='span-2-b div-km']//p[@class='size-12-bold km-texto']",
                fun=xmlValue)

x <- getNodeSet(doc=prs,
                path="//div[@class='span-2-b div-ano']//p[@class='size-12-bold ano-texto']",
                fun=xmlValue)

##-----------------------------------------------------------------------------
