% Load the dataset and define the variables
% -----------------------------------------
clear all;
close all;
N=1000;
[y,x,w,z]=genexample_bin(N);

%load dados;
%w = data(:,[1:24,27]);
%w(:,8)=[];
%x = data(:,[25,26]);
%z = [];
%y = data(:,28);

qx = size(x,2); % Number of variables in x
qz = size(z,2); % Number of variables in z
qw = size(w,2); % Number of variables in w
N  = size(y,1); % Number of observations

for i=1:qx
    x(:,i)=x(:,i)./std(x(:,i));
end

Tindex = []; % Set of indexes of the terminal nodes
Jindex = []; % Set of indexes of the parent nodes
Sindex = []; % Set of indexes of the transition (split) variables

criticalvalue = 0.05;   % Starting critical values for the sequence of LM tests.
varrho = 0.5;           % Decaying factor for the significance of the LM tests.    

% Test linearity against a STR-Tree with a single split
% -----------------------------------------------------
[pvalue,Jbest,sbest]=lmtest_bin(y,x,w,z,ones(N,1),[],[],[],1,qx,qz,N,[],[]);

if pvalue<=criticalvalue
    growtree=1;
    Jindex=[0];
    Tindex=[1;2];
    Sindex=[sbest];
    n=[1;0];
    nT=length(Tindex);
    nJ=length(Jindex);
    nS=length(Sindex);
else
    growtree=0;
end

g=[];
c=[];
while growtree==1
    [g,c,beta,lambda,B,h,yhat,e,jacobian,d,D,phat]=strestimation_bin(y,x,w,z,Tindex,Jindex,Sindex,nT,nJ,nS,n,qz,N,g,c)
    
    criticalvalue=criticalvalue*varrho;
    
    [pvalue,Jbest,sbest]=lmtest_bin(y,x,w,z,B,h,e,Tindex,nT,qx,qz,N,d,D);
    
    if pvalue<=criticalvalue
        growtree=1;
        % Creates new set of parent nodes
        % -------------------------------
        Jindex=sort([Jindex;Jbest]);
        
        % Removes new parent node from the list of terminal nodes
        % -------------------------------------------------------
        inewJ=find(Tindex==Jbest);
        Tindex(inewJ)=[];
        Tindex=sort([Tindex;2*Jbest+1;2*Jbest+2]);
        Sindex=[Sindex;sbest];
        nT=length(Tindex);
        nJ=length(Jindex);
        nS=length(Sindex);
        
        % Creates new matrix n
        % --------------------
        n=buildn_bin(Tindex,Jindex,nT,nJ);
    else
        growtree=0;
    end
end