function [g,c,beta,lambda,B,h,yhat,e,jacobian,d,D,phat]=strestimation_bin(y,x,w,z,Tindex,Jindex,Sindex,nT,nJ,nS,n,qz,N,g,c)



[g,c,bestcost]=startval_bin(y,x,w,z,Tindex,Jindex,Sindex,nT,nJ,nS,n,qz,N,40,g,c);


X=[g;c];

bestcost

options = optimset('Display','iter','Jacobian','on','MaxFunEvals',1e10,'LargeScale','off','MaxIter',10000,'TolFun',1e-5,'DerivativeCheck','off','LevenbergMarquardt','on','LineSearchType','cubicpoly','TolX',1e-5);
[X,resnorm,residual,exitflag,output,theta,jacobian]=lsqnonlin('qmle_bin',X,[],[],options,y,x,w,z,Tindex,Jindex,Sindex,nT,nJ,nS,n,qz,N);
iterations=output.iterations;

g = X(1:nJ);
c = X(nJ+1:2*nJ);

% Concentrated maximum likelihood: Given g and c, find beta and lambda
% --------------------------------------------------------------------
[phi,B,yhat,phat]=strgen_bin(X,y,x,w,z,Sindex,nT,nJ,n,qz,N);

beta   = phi(1:nT*(qz+1));
lambda = phi(nT*(qz+1)+1:length(phi));

e=y-phat;

%----------%
% DEVIACE  %
%----------%
for i=1:N
if yhat(i,:)==0
   d(i,:)=-2*log(1-phat(i,:));
else
   d(i,:)=-2*log(phat(i,:));
end
end
D=sum(d(:));

% Derivative estimation
% ----------------------
h=[];
for i=1:nT
    haux=[ones(N,1) z].*repmat(B(:,i),1,qz+1);
    h=[h haux];
end
h=[h,-jacobian];
h=[h,w];