function [f,dH]=qmle_bin(X,y,x,w,z,Tindex,Jindex,Sindex,nT,nJ,nS,n,qz,N)

[phi,B,yhat,phat]=strgen_bin(X,y,x,w,z,Sindex,nT,nJ,n,qz,N);

[dBgamma,dBc] = genjacobian_bin(X,x,Sindex,nT,nJ,n,N);

zaux = [ones(N,1) z];
beta = phi(1:nT*(qz+1));

% Derivative with respect to gamma
% --------------------------------
for i=1:nT
    for j=1:nJ
        Dgamma(:,i,j)=zaux*beta((i-1)*(qz+1)+1:(qz+1)*i).*dBgamma(:,i,j);
        Dc(:,i,j)=zaux*beta((i-1)*(qz+1)+1:(qz+1)*i).*dBc(:,i,j);
    end
end
Dgamma=squeeze(sum(Dgamma,2));
Dc=squeeze(sum(Dc,2));

dH=-[Dgamma Dc];

e = y-phat;
f = e;
    