function [Dgamma,Dc] = genjacobian_bin(X,x,Sindex,nT,nJ,n,N)

g = X(1:nJ,1);
c = X(nJ+1:2*nJ,1);

% Generate the derivatives of the membership functions
% ----------------------------------------------------
for i=1:nT
    for j=1:nJ
        G   = logsigmoid_bin(g(j)*x(:,Sindex(j)),g(j)*c(j));
        G_  = 1-G;
        n_1 = n(i,j)*(1+n(i,j))/2;
        n_2 = (1-n(i,j))*(1+n(i,j));
        Aaux=n_1*(G.^(max(0,n_1-1))).*(G_.^n_2)-n_2*(G_.^(max(0,n_2-1))).*(G.^n_1);
        A(:,1)=Aaux.*(G.*G_).*(x(:,Sindex(j))-c(j));
        A(:,2)=-Aaux.*(G.*G_)*g(j);
                             
        B=ones(N,1);
        for j2=1:nJ
            if j2~=j
                G2   = logsigmoid_bin(g(j2)*x(:,Sindex(j2)),g(j2)*c(j2));
                G2_  = 1-G2;
                n2_1 = n(i,j2)*(1+n(i,j2))/2;
                n2_2 = (1-n(i,j2))*(1+n(i,j2));
                B    = B.*((G2.^n2_1).*(G2_.^n2_2));
            end    
        end
        Dgamma(:,i,j) = A(:,1).*B;
        Dc(:,i,j) = A(:,2).*B;
    end
end