function [y,x,w,z]=genexample_bin(N)

N=1000;
x(:,1)=randn(N,1);
x(:,2)=0.5+0.3*(randn(N,1));
x(:,3)=1-0.5*randn(N,1);

x(:,1)=x(:,1)./std(x(:,1));
x(:,2)=x(:,2)./std(x(:,2));
x(:,3)=x(:,3)./std(x(:,3));

%z(:,1)=0.9+0.8*randn(N,1);
%z(:,2)=1-0.5*randn(N,1);
%z(:,3)=x(:,2);

z=x;

%w(:,1)=sqrt(rand(N,1)+10);

e=0.5*randn(N,1);

%beta=[-1;2.4;1.4;0.9;-0.5;1.0;-3.5;2.8];
beta=[-1;2.4;1.4;0.9;0.6;0.22;-0.5;0.12;-0.4;0.3;-0.17;0.37;1.9;3.5;-0.8;0.6];
%lambda=[-0.8];
w=[];

g(1)=30;
g(2)=40;
g(3)=60;
c(1)=-0.4;
c(2)=1.7;
c(3)=0.8;

Tindex=[2 3 9 10]; % Set of indexes of the terminal nodes
Jindex=[0 1 4];    % Set of indexes of the parent nodes
Sindex=[1 3 2];    % Set of indexes of the transition (split) variables

nT=size(Tindex,2);              % Length of Tindex
nJ=size(Jindex,2);              % Length of Jindex
n=buildn_bin(Tindex,Jindex,nT,nJ);
qz=size(z,2);

zB=[];
for i=1:nT
    B(:,i)=ones(N,1);
    for j=1:nJ
        G   = (logsigmoid_bin(g(j)*x(:,Sindex(j)),g(j)*c(j)));
        Gaux(:,j)=G;
        G_  = 1-G;
        n_1 = n(i,j)*(1+n(i,j))/2;
        n_2 = (1-n(i,j))*(1+n(i,j));
        
        B(:,i) = B(:,i).*((G.^n_1).*(G_.^n_2));
    end
    if isempty(z)==0
        zB = [zB z.*repmat(B(:,i),1,qz)];
    end
end
Z=[B zB];

eta=Z*beta;

p = exp(eta)./(1+exp(eta));
 
u = rand(N,1);
 
 for j=1:N
   if  p(j,:) < u(j,:);
       y(j,:) = 1;
   else
       y(j,:) = 0;
   end
 end
 y;