\name{reg}

\alias{reg}
\alias{reg1}
\alias{reg2}
\alias{reg.aux}

%- Also NEED an `\alias' for EACH other topic documented here.
\title{PAD - Ilustração de modelos de regressão}

\description{
  Esta função pega argumentos que definem um modelo de regressao com uma
  ou duas variaveis esplicativas e grafico dos dados,
  modelo de regressao e residuos.
}

\usage{
reg(n.expl, ...)

reg1(true.model, n.points, range.x, regular, x,  ...)

reg2(true.model, n.points, range.x1, range.x2,  
     regular, x1, x2, ...)
}

%- maybe also `usage' for other objects documented here.
\arguments{
  \item{n.expl}{o numero de variaveis explicativas. Os unicos valores sao 1 ou 2. }
  \item{true.model}{uma equacao definindo o verdadeiro modelo de regressao.
    Exemplos de especificacoes sao:\cr
    \eqn{2 + 3*x} para uma variavel explicativa e\cr
    \eqn{3 + 2*x1 - 3*x2} para duas variaveis explicativas}
  \item{range.x, range.x1, range.x2}{um vetor numerico de dois elementos com os valores minimos e
    maximos para as variaveis explicativas  }
  \item{n.points}{numero de pontos dos dados}
  \item{regular}{logico. \code{TRUE} (o padrao) indica que os valores da
    variavel explicativa sera regularmente espacado entre o dominio de
    \eqn{x}. \code{FALSE} signifíca que os valores de \eqn{x} serao amostrados do dominio de \eqn{x}   }
  \item{x, x1, x2}{objetos (vetor) ou entrada de teclado com valores de
    variaveis explicativas. Somente usado se \code{range.x}  e
    \code{range.y} nao sao fornecidos. }
  \item{\dots}{argumentos adicionais a serem passados para a funcao plot}
}

\details{
  A funcao principal \code{reg} indaga pelo numero de variaveis explicativas 
e entao chama \code{reg1}  ou \code{reg2} para o 
caso de um ou dois respectivamente.
  A funcao pega um modelo ``verdadeiro'' e valores para as variaveis 
  explicativas e constroi uma variavel de resposta disto,
adicionando a variavel resposta um erro equivalente a 20\% de sua variancia.
  O ajuste e o resultado de um modelo de regressao linear esta ilustrado no dispositivo grafico.
}

\value{
  A função \code{reg1} produz um plot 2D dos dados contra
  a variavel exploratoria e adiciona uma linha com o modelo de regressao ajustado.

Se o pacote \code{\link[scatterplot3d]{scatterplot3d}} estiver disponivel,
  a funcao \code{reg2} produz um plot 3D dos dados contra as 
variaveis explicativas
  e adiciona um plano com o modelo de regressao ajustado para a area.

  Em ambos casos um segundo grafico com os residuos contra os valores ajustados e produzido.
}

%\references{ ~put references to the literature/web site here ~ }

%\author{
%  Peter J. Diggle \email{p.diggle@lancaster.ac.uk} \cr
%  Paulo Justiniano Ribeiro Jr. \email{p.ribeiro@lancaster.ac.uk}.
%}

%\note{ ~~further notes~~ }

% ~Make other sections like WARNING with \section{WARNING }{....} ~

\seealso{\code{\link{lm}}, \code{\link[scatterplot3d]{scatterplot3d}}.  }

\examples{
reg(1, "1 + 3*x", n.p = 21, range.x = c(0,20), reg = TRUE)
reg(1, "1 + 3*log(x^2)", n.p=25, range.x = c(1, 100), reg=TRUE)
reg(1, "10 - 2*exp(-x/10)", x = 1:30)
##
reg(2, "10 - 5*x1 + 3*x2" , x1 = runif(25), x2 =runif(25))
reg(2, "1+ 3*sqrt(x1) -2*x2^2" , n.p=50, range.x1=c(10, 30),
    range.x2 =c(1, 5))
#
# Para uma entrada interativa faça
\dontrun{
reg()
}
}
\keyword{dplot}

