\name{mctest}

\alias{mctest}
\alias{plot.mctest}
\alias{print.mctest}

\title{PAD  -  Pareamento e Teste Monte Carlo para duas amostras}

\description{
  Efutua o teste Monte Carlo para amostra pareada ou analise de duas amostras. \cr
\code{plot.mctest} produz um delineamento grafico e mostra os resultados do teste Monte Carlo.
}

\usage{
mctest(x, y, paired = TRUE, nsim, plot = TRUE)

\method{plot}{mctest}(x, tcurve = TRUE, \dots)

\method{print}{mctest}(x, \dots)
}

%- maybe also `usage' for other objects documented here.

\arguments{
  \item{x}{um vetor numerico com os dados da primeira variavel}
  \item{y}{um vetor numerico com os dados da segunda variavel}
  \item{paired}{Logico indicando a forma que o teste pareado deve ser efetuado. 
        O padrao e \code{FALSE} que implica em analise de duas amostras.  }
  \item{nsim}{Um inteiro com o numero de amostras Monte Carlo. 
	O padrao e 1000.  }
  \item{plot}{Logico. Se \code{TRUE} o grafico e altomaticamente produzido.  }
  \item{tcurve}{Logico indicando a forma que a curva da distribuicao t deve se adicionada ao grafico.  }
  \item{\dots}{nao usado.  }
}

\details{
  
  \bold{Dados Pareados}
  
  \enumerate{
    \item{1}{Para o \eqn{n} pares de dados \eqn{(x_i, y_i)} calcula diferencas 
       \eqn{d_i = x_i - y_i} e entao o a estatistica de teste:
      \deqn{\frac{\overline{d}}{\sqrt{\frac{Var(d)}{n}}}}{%
	(mean(d))/(sqrt(Var(d)/n))}
    }
    
    \item{2}{Para cada para re-aloca is dois dados em dois grupos aleatorios.
	     Entao re-calcula o teste estatistico acima. }
    
    \item{3}{repete o passo anterior \eqn{nsim} vezes. Isto gera uma distribuicao empirica para o teste estatistico.  }
    
    \item{4}{compara a estatistica calculada com os dados da distribuicao empírica.}
  }
  
  
  \bold{Duas Amostras}
  
  Para o teste de duas amostras um teste de aleatorizacao e efetuado como segue:

  \enumerate{
    \item{1}{Para duas amostras independentes \eqn{x} e \eqn{y}
      de tamanhos \eqn{n_x} e \eqn{n_y} define
      \deqn{S^2 = \frac{(n_x-1) Var(x) + (n_y -1) Var(y)}{n_x + n_y - 2}}{%
	S^2 = ((n_x-1) Var(x) + (n_y -1) Var(y))/(n_x + n_y - 2)}
      e calcula a seguinte estatistica:
      \deqn{\frac{\overline{x} - \overline{y}}{\sqrt{S^2 (\frac{1}{n_x} +
      \frac{1}{n_y})}}}{%
	(mean(x) - mean(y))/sqrt(S^2 * (1/n_x + 1/n_y))}
    }
    
    \item{2}{Coloca \eqn{n_x + n_y} juntos dos dados e re-aloca aleatoriamente para dois grupos de tamanhos
      \eqn{n_x} e \eqn{n_y}.}
    
    \item{3}{repete o passo anterior \eqn{nsim} vezes. Isto gera uma distribuicao empirica para o teste estatistico.  }
    
    \item{4}{compara as estatisticas calculadas para os dados com a distribuicao empirica.}
}      
  
  Para os dois casos a estatistica de teste dos dados originais e comparada com a distribuicao
  empirica  de forma a produzir \emph{P-values}.
  A probabilidades das caldas Superior e Inferior sao calculadas contando quantos
  valores da estatistica calculada para os dados simulados estao acima e abaixo
  do valor obtido no dado original.
  
  Adicionalmente, \emph{valores-P} baseados na distribuicao \code{t} tambem sao informados.
  
}

\value{
  A funcao \code{mctest} retorna um objeto da classe
  \code{mctest} que e uma lista de componentes:
  \item{p}{um vetor numerico com as probabilidades das caldas superiores e inferiores
    baseadas na distribuicao empirica.  }
  \item{pt}{um vetor numerico com as probabilidade das caldas superiores e inferiores
    baseadas na distribuicao \code{t}.  }
  \item{data.statistic}{a estatistica calculada acima para os dados originais.  }
  \item{sim.statistic}{a estatistica calculada acima para cada simulacao.  }
  A funcao \code{plot.mctest} produz um histograma da distribuicao empirica
  com uma indicação dos valores das estatisticas do dado.
  Uma distribuicao \code{t} pode ser adicionada ao grafico.
}

%\references{}

%\author{
%  Peter J. Diggle \email{p.diggle@lancaster.ac.uk} \cr
%  Paulo Justiniano Ribeiro Jr. \email{p.ribeiro@lancaster.ac.uk}.
%}

%\note{ ~~further notes~~ }

% ~Make other sections like WARNING with \section{WARNING }{....} ~

%\seealso{ ~~objects to SEE ALSO as \code{\link{~~fun~~}}, ~~~ }

\examples{
##
## Um teste de duas amostras
##
data(mandibula)
mctest(mandibula$femea, mandibula$macho, paired = FALSE)
#
# Para uma entrada interativa faca:
\dontrun{
mctest()
}
}
\keyword{htest}
