\name{grav}
\docType{data}

\alias{grav}

\title{PAD  -  Dados de Gravidade}

\usage{data(grav)}

\description{
O \code{grav} data frame tem 22 linhas e 2 colunas.
}

\format{
  Este data frame contem as seguintes colunas:
  \describe{
    \item{time}{um vetor numerico com o tempo necessario para queda (segundos)}
    \item{distance}{um vetor numerico com a distancia vertical de queda (cm)}
  }
}

\details{
Estes dados sao provenientes de um experimento de graduação para estimar o valor da constante gravitacional, \emph{g} (a aceleracao de um corpo em queda livre na superficie terrestre. Para cada repeticao do experimento (linha de dados) um orbe foi liberado a partir de uma altura pre-determinada, altura acima do trabalho e do tempo foi gravado, tal como descrito nas notas de aula.
}

%\source{
% ~~ reference to a publication or URL from which the data were obtained ~~
%}

%\references{
%~~ possibly secondary sources and usages ~~
%}

\examples{
##
## Carregando os dados
##
data(grav)
##
## Anexando o the data frame
##
attach(grav)
##
## Delineando os dados originais
##
plot(distancia, tempo)
##
## Agora incluindo o intercepto
##
plot(distancia, tempo, xlim=c(0,max(distancia)), ylim=c(0,max(tempo)))
##
## transformando as distancias vetoriais
##
dt <- sqrt(distancia)
plot(dt, tempo, xlim=c(0,max(dt)), ylim=c(0,max(tempo)))
##
## desenhando modelos montados sem e com intercepto

##
abline(lm(tempo~dt-1))
abline(lm(tempo~dt), lty=2)
##
detach()
}

\keyword{datasets}
