\name{defcobre}
\docType{data}

\alias{defcobre}


\title{PAD  -  Dados de deformacao do cobre}

\usage{data(defcobre)}

\description{
O \code{defcobre} data frame tem 8 linhas e 5 colunas.
}

\format{
  Este data frame contem as seguintes colunas:
  \describe{
    \item{temperatura}{um vetor numerico com temperaturas (graus centigrados)}
    \item{Cu40}{um vetor numerico com a deformacao do cobre quando teor 40\%}
    \item{Cu60}{um vetor numerico com a deformacao do cobre quando teor 60\%}
    \item{Cu80}{um vetor numerico com a deformacao do cobre quando teor 80\%}
    \item{Cu100}{um vetor numerico com deformacao do cobre quando teor 100\%}
  }
}

\details{
Estes dados sao para um experimento fatorial para investigar
como placas metalicas com diferentes niveis de teor de cobre se deformam com diferentes temperaturas. Deformacao e indesejavel.
}

%\source{
% ~~ reference to a publication or URL from which the data were obtained ~~
%}
%\references{
%~~ possibly secondary sources and usages ~~
%}

\examples{
data(defcobre)
matplot(x=defcobre[,1], y=defcobre[,-1], ty="l", xlab="Temperatura", ylab="deformacao")
legend(50, 15, c("40\%", "60\%", "80\%", "100\%"), lty=1:4, col=1:4)
}
\keyword{datasets}
