"tcl" <- function(x, n, nsim, plot = TRUE, ncols = 2) {
  par.now <- par(no.readonly = TRUE)
  on.exit(par(par.now))
  ##
  if(missing(x))
    x <- eval(parse(prompt=" entre com um vetor de valores de dados \n(um objeto, uma expressao ou use o formato c() para entrar com um vetor numerico),
\n  x = "))
  if(any(is.na(x)) | !is.numeric(x))
    stop("um vetor numerico \"x\" deve ser fornecido")
  if(missing(n)){
    cat("\n entre com o tamanho das amostras, <return> assumira esses valores c(2,4,8,16,32)\n")
    n <- as.numeric(readline("n = "))
  }
  if(any(is.na(n)) | n == "") n <- c(2,4,8,16,32)
  if(any(is.na(n)) | (!is.numeric(n) && !is.integer(n)))
    stop("um valor de numero inteiro para \"n\" deve ser fornecido")
  if(missing(nsim)){
    cat("\n entre com o numero de simulacoes sim, \n <return> assumira esse valor 1000\n")
    nsim <- as.numeric(readline(prompt="nsim = "))
  }
  if(any(is.na(nsim)) | nsim == "") nsim <- 1000
  if(any(is.na(nsim)) |  (!is.numeric(nsim) && !is.integer(n)))
    stop("um valor de numero inteiro para \"nsim\" deve ser fornecido")
  ##
  cat("\nsampling  ...  ")
  res <- list(data = x)
  for(nsz in n){
    sims <- matrix(0,nsim,nsz)
    for (i in 1:nsim)
      sims[i,] <- sample(x, nsz, replace = TRUE)
    xbar <- apply(sims, 1, mean)
    sd <- sqrt(apply(sims, 1, var))
    res[[paste("tamanho", nsz, sep=" ")]] <- list(xbar = xbar, sd = sd)
  }
  class(res) <- "tcl"
  cat("done.\n\n")
  if(plot){
    par(mfrow=c(ceiling((length(n)+1)/ncols),2),
        mar=c(3,2.5,2,.5), mgp=c(1.7,.7,0))
    plot.tcl(res)
  }
  return(invisible(res))
}

"plot.tcl" <- function(x, ...){
  hist(x$data, main = "", probability=TRUE, xlab=expression(bar(x)), ylab="Densidade")
  mtext("populacao original")
  nx <- length(x)
  lims <- function(y){
    ind.hist <- hist(y$xbar, probability=TRUE, plot=FALSE)
    return(c(range(ind.hist$breaks), range(ind.hist$dens)))
  }
  h.lims <- sapply(x[-1], lims)
  xymin <- apply(h.lims[c(1,3),,drop=FALSE], 1, min)
  xymax <- apply(h.lims[c(2,4),,drop=FALSE], 1, max)
  for(i in 2:nx){
    hist(x[[i]]$xbar, prob = TRUE, xlab=expression(bar(x)),
         ylab="densidade", main = "",
         xlim = c(xymin[1], xymax[1]), ylim = c(0, xymax[2]))
    mtext(paste("amostra de",names(x)[i]))
  }
  return(invisible())
}

"tcl.plot1" <- function(x, nsim) {
  data <- NULL
  for (i in 1:nsim) {
    data <- c(data, sample(x,1, replace=TRUE))
  }
  xl <- c(floor(min(data)-5),floor(max(data)+5))
  hist(data,xlim=xl,xlab="dados",ylab="frequencia")
  for (i in 1:nsim) {
    data <- c(data, mean(sample(x,2, replace=TRUE)))
  }
  hist(data,xlab="medias para 2",ylab="frequencia",xlim=xl)
  for (i in 1:nsim) {
    data <- c(data, mean(sample(x,4, replace=TRUE)))
  }
  hist(data,xlab="medias para 4",ylab="frequencia",xlim=xl)
  
  for (i in 1:nsim) {
    data <- c(data, mean(sample(x,8, replace=TRUE)))
  }
  hist(data,xlab="medias para 8",ylab="frequencia",xlim=xl)
}

"tcl.plot2" <- function(nsim) {
  data(turma98)
  xbar <- matrix(0,3,4)
  xvar <- xbar
  
  x <- turma98[,1]
  x <- x[!is.na(x)]
  junk <- tcl(x,1,nsim)
  xbar[1,1] <- mean(junk$xbar); xvar[1,1] <- var(junk$xbar)
  
  junk <- tcl(x,2,nsim)
  xbar[1,2] <- mean(junk$xbar); xvar[1,2] <- var(junk$xbar)
  
  junk <- tcl(x,4,nsim)
  xbar[1,3] <- mean(junk$xbar); xvar[1,3] <- var(junk$xbar)
  
  junk <- tcl(x,8,nsim)
  xbar[1,4] <- mean(junk$xbar); xvar[1,4] <- var(junk$xbar)
  
  x <- turma98[,2]
  x <- x[!is.na(x)]
  junk <- tcl(x,1,nsim)
  xbar[2,1] <- mean(junk$xbar); xvar[2,1] <- var(junk$xbar)
  
  junk <- tcl(x,2,nsim)
  xbar[2,2] <- mean(junk$xbar); xvar[2,2] <- var(junk$xbar)
  
  junk <- tcl(x,4,nsim)
  xbar[2,3] <- mean(junk$xbar); xvar[2,3] <- var(junk$xbar)
  
  junk <- tcl(x,8,nsim)
  xbar[2,4] <- mean(junk$xbar); xvar[2,4] <- var(junk$xbar)
  
  x <- -50*log(runif(50))
  x <- x[!is.na(x)]
  junk <- tcl(x,1,nsim)
  xbar[3,1] <- mean(junk$xbar); xvar[3,1] <- var(junk$xbar)
  
  junk <- tcl(x,2,nsim)
  xbar[3,2] <- mean(junk$xbar); xvar[3,2] <- var(junk$xbar)
  
  junk <- tcl(x,4,nsim)
  xbar[3,3] <- mean(junk$xbar); xvar[3,3] <- var(junk$xbar)
  
  junk <- tcl(x,8,nsim)
  xbar[3,4] <- mean(junk$xbar); xvar[3,4] <- var(junk$xbar)
  list(xbar=xbar, xvar=xvar)
}

