"reg" <- function(n.expl, ...)
{
  par.now <- par(no.readonly=TRUE)
  on.exit(par(par.now))
  if(missing(n.expl)){
    cat("entre com a quantidade de variaveis explicativas (1 ou 2)\n")
    n.expl <- eval(parse(prompt = "número = "))
  }
  if(any(n.expl == c(1,2))){
    par(mfrow=c(2,1), mar=c(2.5,2.5,2,0.5), mgp=c(1.5, .6, 0))
    if (n.expl == 1) reg1(...)
    else reg2(...)
  }
  else stop("numero de variaveis explicativas deve ser 1 ou 2" )
  return(invisible())
}

"reg1" <- function(true.model, n.points, range.x, regular, x, ...){
  if(missing(true.model)){
    cat("entre com a equacao do modelo (use um formato como: 1 + 2*x):\n ")
    true.model <- parse(prompt = "modelo: ")
  }
  else true.model <- parse(text=true.model)
  cat("\n Informacao sobre a primeira variavel explicativa:\n")
  x <- reg.aux(range.x = range.x, n.points = n.points,
               regular = regular, xvec = x)
  x <- x[order(x)]
  ym <- eval(true.model)
  y <- ym + rnorm(length(ym), mean=0, sd = sqrt(0.20 * var(ym)))
  plot(x, y, main=paste("modelo :  Y = ",true.model), ...)
  lines(spline(x, ym), lty=2)
  if(mean(diff(ym)) > 0) xleg <- min(x)
  if(mean(diff(ym)) < 0) xleg <- 0.8 * (diff(range(x)))
  legend(xleg, max(y), c("empirico", "ajustado"), lty=c(2,1))
  regs <- lm(y ~ x)
  abline(regs)
  ##
  nv <- length(y) - 1
  stdres <- regs$resid/sqrt(nv * var(regs$res)/(nv-1))
  emax <- max(abs(stdres))
  plot(regs$fit, stdres, xlab="valores ajustados",
       ylab = "residuo padronizado", ylim=c(-emax, emax))
  abline(h=0, lty=2)  
  return(invisible())
}

"reg2" <- function(true.model, n.points, range.x1, range.x2, regular, x1, x2, ...){
  if(missing(true.model)){
    cat("entre com a equacao do modelo (use um formato como: 1 + 2*x1 + 3*x2):\n ")
    true.model <- parse(prompt = "modelo : ")
  }
  else true.model <- parse(text=true.model)
  regular <- FALSE  
  if(missing(x1)){
    cat("\n Informacao sobre a primeira variavel explicativa:\n")
    x1 <- reg.aux(range.x = range.x1, n.points = n.points,
                  regular = regular, xvec = x1)
  }
  else if(!is.numeric(x1)) stop("x1 deve ser um vetor numerico")
  if(missing(x2)){
    cat("\n Informacao sobre a segunda variavel explicativa:\n\n")
    x2 <- reg.aux(range.x=range.x2, n.points=eval(attr(x1,"n")),
                  regular=regular, xvec = x2)
  }
  else if(!is.numeric(x1)) stop("x1 deve ser um vetor numerico")
  if(length(x1) != length(x2))
    stop("x1 e x2 possuem tamanhos diferentes")
  ym <- eval(true.model)
  y <- ym + rnorm(length(ym), mean=0, sd = sqrt(0.20 * var(ym)))
  regs <- lm(ym ~ x1 + x2)
  if(require(scatterplot3d)){
    yx1x2 <- scatterplot3d::scatterplot3d(data.frame(x1=x1, x2=x2, y=y),
                           type="h", highlight.3d=FALSE,
                           angle=40, box=FALSE,
                           pch=16, main=paste("modelo :  Y = ",true.model))
    yx1x2$plane3d(regs)
  }
  else
    warning("pacote \"scatterplot3d\" nao encontrado. plot 3D nao pode ser feito ") 
  ##
  nv <- length(y) - 1
  stdres <- regs$resid/sqrt(nv * var(regs$res)/(nv-2))
  emax <- max(abs(stdres))
  plot(regs$fit, stdres, xlab="valores ajustados", ylab = "residuo padronizado",
       ylim=c(-emax, emax))
  abline(h=0, lty=2)  
  return(invisible())
}

"reg.aux" <- function(range.x, n.points, regular, xvec){
  if(missing(xvec)){
    if(missing(n.points)){
      cat("   entre o numero de pontos ou pressione <return> para entra com um vetor de valores da variavel explicativa\n") 
      n.points <- as.numeric(readline(prompt = "n.pontos = "))
    }
    if(is.null(n.points) || any(is.na(n.points))){
      cat("   entre um vetor com os valores de x\n")
      xvec <- eval(parse(prompt = "xvec = "))
      if(!is.numeric(xvec))
        stop("valores nao-numericos invalidos para xvec")
      n.points <- length(xvec)
    }
    else{
      if(missing(range.x)){
        cat("   entre com o dominio dos valores para as variaveis explicativas\n")
        xmin <- as.numeric(readline(prompt = "      minimo = "))
        xmax <- as.numeric(readline(prompt = "      maximo = "))
        if(is.null(xmin)) xmin <- "vetor x pelo usuario"
        if(is.null(xmax)) xmax <- "vetor x pelo usuario"
        if(all(is.na(xmin))) xmin <- "vetor x pelo usuario"
        if(all(is.na(xmax))) xmax <- "vetor x pelo usuario"
        range.x <- c(xmin, xmax)
        range.x <- range.x[order(range.x)]
      }
      range.x <- range.x[order(range.x)]
      if(is.numeric(range.x)){
        if(missing(regular)){
          cat("   pontos regularmente espaçados? (o padrao é TRUE)\n")
          regular <- as.logical(readline(prompt = "      (T ou F) = "))
        }
        if(is.null(regular) || any(is.na(regular))) regular <- TRUE
        if(regular) xvec <- seq(range.x[1], range.x[2], l=n.points)
        else{
          xvec <- runif(n.points, min=range.x[1], max=range.x[2])
        }
      }
    }
  }
  else n.points <- length(xvec)
  attr(xvec, "n") <- n.points
  return(xvec)
}

