\name{warping}
\docType{data}

\alias{warping}


\title{PAD  -  Warping of Cu material data}

\usage{data(warping)}

\description{
The \code{warping} data frame has 8 rows and 5 columns.
}

\format{
  This data frame contains the following columns:
  \describe{
    \item{temperature}{a numeric vector with temperature (degrees centrigrade)}
    \item{Cu40}{a numeric vector with extent of warping with Cu content 40\%}
    \item{Cu60}{a numeric vector with extent of warping with Cu content 60\%}
    \item{Cu80}{a numeric vector with extent of warping with Cu content 80\%}
    \item{Cu100}{a numeric vector with extent of warping with Cu content 100\%}
  }
}

\details{
These data are from a factorial experiment to investigate
how metal plates with different levels of copper content
warp when subjected to different temperatures. Warping
is undesirable.
}

%\source{
% ~~ reference to a publication or URL from which the data were obtained ~~
%}
%\references{
%~~ possibly secondary sources and usages ~~
%}

\examples{
data(warping)
matplot(x=warping[,1], y=warping[,-1], ty="l", xlab="Temperature", ylab="warping")
legend(50, 15, c("40\%", "60\%", "80\%", "100\%"), lty=1:4, col=1:4)
}
\keyword{datasets}
