\name{reg}

\alias{reg}
\alias{reg1}
\alias{reg2}
\alias{reg.aux}

%- Also NEED an `\alias' for EACH other topic documented here.
\title{PAD - Illustration of regression models}

\description{
  These functions takes arguments defining a regression model with one
  or two explanatory variables and plots the data,
  regression model and residuals.
}

\usage{
reg(n.expl, ...)

reg1(true.model, n.points, range.x, regular, x,  ...)

reg2(true.model, n.points, range.x1, range.x2,  
     regular, x1, x2, ...)
}

%- maybe also `usage' for other objects documented here.
\arguments{
  \item{n.expl}{the number of explanatory variables. The only values 
allowed are 1 or 2.  }
  \item{true.model}{a equation defining the true regression model.
    Examples of specifications are:\cr
    \eqn{2 + 3*x} for one explanatory variable and \cr
    \eqn{3 + 2*x1 - 3*x2} for two explanatory variables}
  \item{range.x, range.x1, range.x2}{a two elements numerical vector with minimum and
    maximum values for the explanatory variable  }
  \item{n.points}{number of data points}
  \item{regular}{logical. \code{TRUE} (the default) indicates that values of the
    explanatory variable will be regularly spaced between the range of
    \eqn{x}. \code{FALSE} means that values of \eqn{x} will be sampled in the range of \eqn{x}   }
  \item{x, x1, x2}{objects (vector) or keyboard input with values of the
    explanatory variable(s). Only used if \code{range.x}  and
    \code{range.y} are not provided. }
  \item{\dots}{further arguments to be passed to the plot function}
}

\details{
  The main function \code{reg} asks for the number of explanatory 
variables and then
  calls \code{reg1}  or \code{reg2} for the 
case of one or two respectively.

  The function takes a ``true'' model and values for the explanatory 
variable(s) and
  build the response variable from this, 
adding to the response variable 
an
  error with variance equivalent to 20\% of its variance.

  A linear regression model is fitted and results are displayed in the
  graphical device.
}

\value{
  The function \code{reg1} produces a 2D plot with data against
  the explanatory variable and adds a line with the fitted regression 
model.

If the packages \code{\link[scatterplot3d]{scatterplot3d}} is available,
  the function \code{reg2} produces a 3D plot with data against the 
explanatory variables
  and adds a plane with the regression model fitted to the data.

  In both cases a second plot with residuals against fitted value is produced.
}

%\references{ ~put references to the literature/web site here ~ }

\author{
  Peter J. Diggle \email{p.diggle@lancaster.ac.uk} \cr
  Paulo Justiniano Ribeiro Jr. \email{p.ribeiro@lancaster.ac.uk}.
}

%\note{ ~~further notes~~ }

% ~Make other sections like WARNING with \section{WARNING }{....} ~

\seealso{\code{\link{lm}}, \code{\link[scatterplot3d]{scatterplot3d}}.  }

\examples{
reg(1, "1 + 3*x", n.p = 21, range.x = c(0,20), reg = TRUE)
reg(1, "1 + 3*log(x^2)", n.p=25, range.x = c(1, 100), reg=TRUE)
reg(1, "10 - 2*exp(-x/10)", x = 1:30)
##
reg(2, "10 - 5*x1 + 3*x2" , x1 = runif(25), x2 =runif(25))
reg(2, "1+ 3*sqrt(x1) -2*x2^2" , n.p=50, range.x1=c(10, 30),
    range.x2 =c(1, 5))
#
# For an interactive input type:
\dontrun{
reg()
}
}
\keyword{dplot}

