\name{queue}

\alias{queue}
\alias{plot.queue}

%- Also NEED an `\alias' for EACH other topic documented here.

\title{PAD  -  Simulation of a Queueing process}

\description{
  This function simulates a stochastic process describing number of
  subjects in a queue.
}

\usage{
queue(lambda, rho, n, plot = TRUE)

\method{plot}{queue}(x, \dots)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{lambda}{a numeric values for the arrival parameter. If not
    provided, a prompt is issue. }
  \item{rho}{a numeric value for the services parameter. If not
    provided, a prompt is issue. }
  \item{n}{an integer value of the number of arrivals. If not
    provided, a prompt is issue. }
  \item{plot}{logical. If \code{TRUE} plot is automaticaly produced.  }
  \item{x}{an output of the function \code{queue}.  }
  \item{\dots}{unused.} 
}

%\details{
%  If arguments
%

\value{
  The function \code{queue} returns 
  a \eqn{(2n + 1) \times 2}{(2n+1) x 2} matrix with columns
  corresponding to cumulative times and number in the queue
  respectively. The class \code{queue} is assigned.

  The function \code{plot.queue} takes an object of the class
  \code{queue} and produces a plot of numbers \em{vs} times.  
}

%\references{ ~put references to the literature/web site here ~ }

\author{
  Peter J. Diggle \email{p.diggle@lancaster.ac.uk} \cr
  Paulo Justiniano Ribeiro Jr. \email{p.ribeiro@lancaster.ac.uk}.
}

%\note{ ~~further notes~~ }

% ~Make other sections like WARNING with \section{WARNING }{....} ~

%\seealso{ ~~objects to SEE ALSO as \code{\link{~~fun~~}}, ~~~ }

\examples{
queue(20, 20, 200)
q1 <- queue(.6, .5, 50, plot = FALSE) 
q1
plot(q1)
# For an interactive input type:
\dontrun{
queue()
}
}
\keyword{datagen}
\keyword{dplot}

