\name{mctest}

\alias{mctest}
\alias{plot.mctest}
\alias{print.mctest}

\title{PAD  -  Paired and two-sample Monte Carlo tests}

\description{
  Performs Monte Carlo tests for paired or two-sample analysis.\cr
  A graphical display of the results is produced by \code{plot.mctest}.
}

\usage{
mctest(x, y, paired = TRUE, nsim, plot = TRUE)

\method{plot}{mctest}(x, tcurve = TRUE, \dots)

\method{print}{mctest}(x, \dots)
}

%- maybe also `usage' for other objects documented here.

\arguments{
  \item{x}{a numeric vector with data on first variable}
  \item{y}{a numeric vector with data on the second variable}
  \item{paired}{logical indicating whether a paired test should be
    performed. Defualts to \code{FALSE} which implies the two-sample
    analysis.  }
  \item{nsim}{an integer with the number of Monte Carlo
    samples. Defaults to 1000.  }
  \item{plot}{logical. If \code{TRUE} plot is automaticaly produced.  }
  \item{tcurve}{logical indicating whether the curve of the t
    distribution should be added to the plot.  }
  \item{\dots}{unused.  }
}

\details{
  
  \bold{Paired data}
  
  \enumerate{
    \item{1}{For the \eqn{n} pairs of data \eqn{(x_i, y_i)} compute the
      differences \eqn{d_i = x_i - y_i} and then
      the test statistic:
      \deqn{\frac{\overline{d}}{\sqrt{\frac{Var(d)}{n}}}}{%
	(mean(d))/(sqrt(Var(d)/n))}
    }
    
    \item{2}{For each pair re-allocate the two data to the two groups
      randomly.  Then re-compute the test statistics above. }
    
    \item{3}{repeat the previous step \eqn{nsim} times. This generates an
      empirical distribution for the test statistics.  }
    
    \item{4}{compare the statistics computed for the data with the
      empirical distribution.}
  }
  
  
  \bold{Two-sample}
  
  For two-sample test a randomization test is performed as follows:

  \enumerate{
    \item{1}{For two independent samples \eqn{x} and \eqn{y}
      of sizes \eqn{n_x} and \eqn{n_y} define
      \deqn{S^2 = \frac{(n_x-1) Var(x) + (n_y -1) Var(y)}{n_x + n_y - 2}}{%
	S^2 = ((n_x-1) Var(x) + (n_y -1) Var(y))/(n_x + n_y - 2)}
      and compute the  following statistics:
      \deqn{\frac{\overline{x} - \overline{y}}{\sqrt{S^2 (\frac{1}{n_x} +
      \frac{1}{n_y})}}}{%
	(mean(x) - mean(y))/sqrt(S^2 * (1/n_x + 1/n_y))}
    }
    
    \item{2}{Pool \eqn{n_x + n_y} data together and re-allocate to the two
      groups of sizes \eqn{n_x} and \eqn{n_y} randomly.}
    
    \item{3}{repeat the previous step \eqn{nsim} times. This generates an
      empirical distribution for the test statistics.  }
    
    \item{4}{compare the statistics computed for the data with the
      empirical distribution.}
  }      
  
  For both cases the test statistic for the original data is compared against the empirical
  distribution in order to produce \emph{P-values}.
  Upper and lower tail probabilities are computed by counting how many
  values of the statistic computed for the simulated data are above and below
  the value obtained for the original data.
  
  Additionally, \emph{P-values} based on the \code{t} distribution are also reported.
  
}

\value{
  The function \code{mctest} returns an object of the class
  \code{mctest} which is a list with components:
  \item{p}{a numerical vector with upper and lower tail probabilities
    based on the empirical distribution.  }
  \item{pt}{a numerical vector with upper and lower tail probabilities
    based on the \code{t} distribution.  }
  \item{data.statistic}{the statistics above computed for the original
    data.  }
  \item{sim.statistic}{the statistics above computed for each
    simulations.  }
  The function \code{plot.mctest} produces a histogram of the empirical
  distribution with an indication to the value of the data statistics.
  A \code{t} distribution can be added to the plot.
}

%\references{}

\author{
  Peter J. Diggle \email{p.diggle@lancaster.ac.uk} \cr
  Paulo Justiniano Ribeiro Jr. \email{p.ribeiro@lancaster.ac.uk}.
  
}

%\note{ ~~further notes~~ }

% ~Make other sections like WARNING with \section{WARNING }{....} ~

%\seealso{ ~~objects to SEE ALSO as \code{\link{~~fun~~}}, ~~~ }

\examples{
##
## A two-sample test
##
data(mandible)
mctest(mandible$female, mandible$male, paired = FALSE)
#
# For an interactive input type:
\dontrun{
mctest()
}
}
\keyword{htest}
