\name{lh}
\docType{data}

\alias{lh}

\title{PAD  -  Cow luteinising hormone data }

\usage{data(lh)}

\description{
The \code{lh} data frame has 100 rows and 8 columns.

This data-set records the concentrations of
luteinising hormone in blood samples taken
at 15-minute intervals from each of 8 cows.

The eight columns correspond to the 8
cows, the rows to the time-sequence of
measurements on each cow.
}

\format{
  This data frame contains the following columns:
  \describe{
    \item{cow1,cow2,cow3,cow4,cow5,cow6,cow7,cow8}{a numeric vector with hormone measurements in \emph{cow1}
      to \emph{cow8}.  }
  }
}

%\details{
%}

\source{
Diggle, P.J. and Zeger, S.L. (1984)  A non-Gaussian model for 
time series with pulses. \emph{JASA} 354-9.
}

%\references{
%~~ possibly secondary sources and usages ~~
%}

\examples{
pmf <- par()$mfrow
##
data(lh)
par(mfrow=c(4,2), mar=c(3,3,3,1))
for(i in 1:length(lh))
  plot(lh[,i], type="l", ylim=range(lh), main=paste("cow", i))
##
par(mfrow=pmf)
}

\keyword{datasets}
