\name{gravity}
\docType{data}

\alias{gravity}

\title{PAD  -  Gravity data}

\usage{data(gravity)}

\description{
The \code{gravity} data frame has 22 rows and 2 columns.
}

\format{
  This data frame contains the following columns:
  \describe{
    \item{time}{a numeric vector with time taken to fall (seconds)}
    \item{distance}{a numeric vector with vertical distance fallen (cm)}
  }
}

\details{
These data are from an undergraduate experiment
to estimate the value of the gravitational
constant, \emph{g} (the acceleration of a free-falling
body at the earth's surface). For each replicate
of the experiment (row of data) a ball-bearing was
released from a pre-determined height above the 
workbench and the time taken before the ball-bearing
hit the workbench was recorded, as described in
the lecture notes.
}

%\source{
% ~~ reference to a publication or URL from which the data were obtained ~~
%}

%\references{
%~~ possibly secondary sources and usages ~~
%}

\examples{
##
## Loading the data
##
data(gravity)
##
## Attaching the data frame
##
attach(gravity)
##
## Ploting original data
##
plot(distance, time)
##
## Now including the intercept
##
plot(distance, time, xlim=c(0,max(distance)), ylim=c(0,max(time)))
##
## transforming the distances vector
##
dt <- sqrt(distance)
plot(dt, time, xlim=c(0,max(dt)), ylim=c(0,max(time)))
##
## plotting fitted models without and with intercept
##
abline(lm(time~dt-1))
abline(lm(time~dt), lty=2)
##
detach()
}

\keyword{datasets}
