\name{clt}

\alias{clt}
\alias{plot.clt}
\alias{clt.plot1}
\alias{clt.plot2}

%- Also NEED an `\alias' for EACH other topic documented here.

\title{PAD  -  Illustrates the Central Limit Theorem}

\description{
  Take samples of size \eqn{n} from a vector of data of size \eqn{N} and computes the empirical
  distribution of the sample mean, illustrating the central limit theorem.
}

\usage{
clt(x, n, nsim, plot = TRUE, ncols = 2)

\method{plot}{clt}(x, \dots)
}

%- maybe also `usage' for other objects documented here.

\arguments{
  \item{x}{a numeric vector with the data}
  \item{n}{an integer defining the sample size}
  \item{nsim}{an integer defining number of samples to be taken}
  \item{plot}{logical. If \code{TRUE} histograms are produced in the graphical device.  }
  \item{ncols}{numerical. The number of columns in the graphical
    device. Only valid if \code{plot = TRUE}. }
  \item{\dots}{unused.} 
}

%%\details{
%  ~~ If necessary, more details than the __description__  above ~~
%}

\value{
  
  Returns a list which is an object of the class 
  \code{clt}. The list components are:

  \item{data}{a vector with the data passed to the function}
  \item{sizeN}{a list with vectors of averages (\code{xbar})  and standard deviations (\code{sd}) of each sample}
  
  For each sample size \eqn{N} provided there will be one component as
  the latter.
  
  \mbox{}
  
  The function \code{hist.clt} plots histograms of the sample means
  on the current graphics device.
  
}

%\references{ ~put references to the literature/web site here ~ }

\author{
  Peter J. Diggle \email{p.diggle@lancaster.ac.uk} \cr
  Paulo Justiniano Ribeiro Jr. \email{p.ribeiro@lancaster.ac.uk}.
}

%\note{ ~~further notes~~ }

% ~Make other sections like WARNING with \section{WARNING }{....} ~

%\seealso{ ~~objects to SEE ALSO as \code{\link{~~fun~~}}, ~~~ }

\examples{
clt(rexp(1000), c(2,4,8,16,32), 1000)
#
par.now <- par(no.readonly=TRUE)
par(mfrow=c(3,2))
data.clt <- clt(exp(rnorm(2000)), c(2,4,8,16,32), 1000, plot=FALSE)
plot(data.clt)
par(par.now)
#
# For an interactive input type:
\dontrun{
clt()
}
}

\keyword{dplot}

