\name{ansc}
\docType{data}

\alias{ansc}

\title{PAD  -  Anscombe quartet data}

\usage{data(ansc)}

\description{
The \code{ansc} data frame has 11 rows and 6 columns.

This synthetic data-set was constructed by the
statistican Frank Anscombe to illustrate how
residuals can be used to discriminate between
data-sets which give identical fitted regression
models.
}

\format{
  This data frame contains the following columns:
  \describe{
    \item{x1}{a numeric vector with explanatory variable for each of
    responses 1, 2 or 3.  }
    \item{y1}{a numeric vector with response 1.  }
    \item{y2}{a numeric vector with response 2.  }
    \item{y3}{a numeric vector with response 3.  }
    \item{x4}{a numeric vector with explanatory variable for response 4}
    \item{y4}{a numeric vector with response 4.  }
  }
}

%\details{
% ~~ If necessary, more details than the _description_ above ~~
%}

\source{
Anscombe, Francis J. (1973) Graphs in statistical analysis. American Statistician, 27, 17-21. 
}

%\references{
%~~ possibly secondary sources and usages ~~
%}

\examples{
data(ansc)
summary(ansc)
parmf <- par()$mfrow
par(mfrow=c(2,2))
with(ansc, plot(x1, y1))
with(ansc, plot(x1, y2))
with(ansc, plot(x1, y3))
with(ansc, plot(x4, y4))
par(mfrow=parmf)
}

\keyword{datasets}
