"reg" <- function(n.expl, ...)
{
  par.now <- par(no.readonly=TRUE)
  on.exit(par(par.now))
  if(missing(n.expl)){
    cat("enter the number of explanatory variables (1 or 2)\n")
    n.expl <- eval(parse(prompt = "number = "))
  }
  if(any(n.expl == c(1,2))){
    par(mfrow=c(2,1), mar=c(2.5,2.5,2,0.5), mgp=c(1.5, .6, 0))
    if (n.expl == 1) reg1(...)
    else reg2(...)
  }
  else stop("number of explanatory variables should be 1 or 2" )
  return(invisible())
}

"reg1" <- function(true.model, n.points, range.x, regular, x, ...){
  if(missing(true.model)){
    cat("enter the true model equation (use a format like: 1 + 2*x):\n ")
    true.model <- parse(prompt = "model : ")
  }
  else true.model <- parse(text=true.model)
  cat("\nInformation on the explanatory variable:\n")
  x <- reg.aux(range.x = range.x, n.points = n.points,
               regular = regular, xvec = x)
  x <- x[order(x)]
  ym <- eval(true.model)
  y <- ym + rnorm(length(ym), mean=0, sd = sqrt(0.20 * var(ym)))
  plot(x, y, main=paste("true model :  Y = ",true.model), ...)
  lines(spline(x, ym), lty=2)
  if(mean(diff(ym)) > 0) xleg <- min(x)
  if(mean(diff(ym)) < 0) xleg <- 0.8 * (diff(range(x)))
  legend(xleg, max(y), c("true", "fitted"), lty=c(2,1))
  regs <- lm(y ~ x)
  abline(regs)
  ##
  nv <- length(y) - 1
  stdres <- regs$resid/sqrt(nv * var(regs$res)/(nv-1))
  emax <- max(abs(stdres))
  plot(regs$fit, stdres, xlab="fitted values",
       ylab = "std residuals", ylim=c(-emax, emax))
  abline(h=0, lty=2)  
  return(invisible())
}

"reg2" <- function(true.model, n.points, range.x1, range.x2, regular, x1, x2, ...){
  if(missing(true.model)){
    cat("enter the true model equation (use a format like: 1 + 2*x1 + 3*x2):\n ")
    true.model <- parse(prompt = "model : ")
  }
  else true.model <- parse(text=true.model)
  regular <- FALSE  
  if(missing(x1)){
    cat("\nInformation on the first explanatory variable:\n")
    x1 <- reg.aux(range.x = range.x1, n.points = n.points,
                  regular = regular, xvec = x1)
  }
  else if(!is.numeric(x1)) stop("x1 must be a numeric vector")
  if(missing(x2)){
    cat("\nInformation on the second explanatory variable:\n\n")
    x2 <- reg.aux(range.x=range.x2, n.points=eval(attr(x1,"n")),
                  regular=regular, xvec = x2)
  }
  else if(!is.numeric(x1)) stop("x1 must be a numeric vector")
  if(length(x1) != length(x2))
    stop("x1 and x2 have different lengths")
  ym <- eval(true.model)
  y <- ym + rnorm(length(ym), mean=0, sd = sqrt(0.20 * var(ym)))
  regs <- lm(ym ~ x1 + x2)
  if(require(scatterplot3d)){
    yx1x2 <- scatterplot3d::scatterplot3d(data.frame(x1=x1, x2=x2, y=y),
                           type="h", highlight.3d=FALSE,
                           angle=40, box=FALSE,
                           pch=16, main=paste("true model :  Y = ",true.model))
    yx1x2$plane3d(regs)
  }
  else
    warning("package \"scatterplot3d\" not found. 3D plot not produced") 
  ##
  nv <- length(y) - 1
  stdres <- regs$resid/sqrt(nv * var(regs$res)/(nv-2))
  emax <- max(abs(stdres))
  plot(regs$fit, stdres, xlab="fitted values", ylab = "std residuals",
       ylim=c(-emax, emax))
  abline(h=0, lty=2)  
  return(invisible())
}

"reg.aux" <- function(range.x, n.points, regular, xvec){
  if(missing(xvec)){
    if(missing(n.points)){
      cat("   enter the number of points or press <return> to enter a vector with the values of the explanatory variable\n") 
      n.points <- as.numeric(readline(prompt = "n.points = "))
    }
    if(is.null(n.points) || any(is.na(n.points))){
      cat("   enter a vector with x values\n")
      xvec <- eval(parse(prompt = "xvec = "))
      if(!is.numeric(xvec))
        stop("invalid non-numeric values for xvec")
      n.points <- length(xvec)
    }
    else{
      if(missing(range.x)){
        cat("   enter the range of values for the explanatory variable\n")
        xmin <- as.numeric(readline(prompt = "      minimum = "))
        xmax <- as.numeric(readline(prompt = "      maximum = "))
        if(is.null(xmin)) xmin <- "vec x by user"
        if(is.null(xmax)) xmax <- "vec x by user"
        if(all(is.na(xmin))) xmin <- "vec x by user"
        if(all(is.na(xmax))) xmax <- "vec x by user"
        range.x <- c(xmin, xmax)
        range.x <- range.x[order(range.x)]
      }
      range.x <- range.x[order(range.x)]
      if(is.numeric(range.x)){
        if(missing(regular)){
          cat("   regularly spaced points? (defaults to TRUE)\n")
          regular <- as.logical(readline(prompt = "      (T or F) = "))
        }
        if(is.null(regular) || any(is.na(regular))) regular <- TRUE
        if(regular) xvec <- seq(range.x[1], range.x[2], l=n.points)
        else{
          xvec <- runif(n.points, min=range.x[1], max=range.x[2])
        }
      }
    }
  }
  else n.points <- length(xvec)
  attr(xvec, "n") <- n.points
  return(xvec)
}

