"queue" <- function(lambda, rho, n, plot = TRUE) {
  if(missing(lambda)){
    cat <- cat("enter a value for the arrival parameter\n")
    lambda <- as.numeric(readline(prompt="lambda = "))
  }
  if(is.na(lambda) | !is.numeric(lambda))
    stop("a numerical value for \"lambda\" must be provided")
  ##
  if(missing(rho)){
    cat("enter a value for the services parameter\n")
    rho <- as.numeric(readline(prompt="rho = "))
  }
  if(is.na(rho) | !is.numeric(rho))
    stop("a numerical value for \"rho\" must be provided")
  ##
  if(missing(n)){
    cat("enter the value for number of arrivals \n")
    n <- as.numeric(readline(prompt="n = "))
  }
  if(is.na(n) | (!is.numeric(n) && !is.integer(n)))
    stop("a numerical integer value for \"n\" must be provided")
  ##
  N <- 2*n
  arrivals <- cumsum(rexp(N)/lambda)
  services <- cumsum(rexp(N)/rho)
  labels <- c(rep(1,N),rep(2,N))
  times <- c(arrivals,services)
  lab <- labels[order(times)]
  size <- 0
  queue <- rep(0,1+2*N)
  for (i in 1:(2*N)) {
    if (lab[i]==1) queue[i+1] <- queue[i]+1
    if (lab[i]==2) queue[i+1] <- max(0,queue[i]-1)
  }
  res <- cbind(times = c(0,sort(times)), queue = queue)[1:(1+N),]
  class(res) <- "queue"
  if(plot)
    plot.queue(res)
  return(invisible(res))
#  return(res)
}

"plot.queue" <- function(x, ...) {
  times <- x[,1]; m <- length(times); tt <- matrix(times[2:m],m-1,2)
  tt <- c(times[1],c(t(tt)))
  heights <- x[,2]; hh <- matrix(heights[1:(m-1)],m-1,2)
  hh <- c(c(t(hh)),heights[m])
  plot(tt, hh, type="l", xlab="time", ylab="queue size")
  return(invisible())
}

