"clt" <- function(x, n, nsim, plot = TRUE, ncols = 2) {
  par.now <- par(no.readonly = TRUE)
  on.exit(par(par.now))
  ##
  if(missing(x))
    x <- eval(parse(prompt="enter a vector with data values \n(an object, an expression or use the format c() to enter a numeric vector),\n  x = "))
  if(any(is.na(x)) | !is.numeric(x))
    stop("a numerical vector \"x\" must be provided")
  if(missing(n)){
    cat("\nenter sample sizes, <return> will assume defaults values c(2,4,8,16,32)\n")
    n <- as.numeric(readline("n = "))
  }
  if(any(is.na(n)) | n == "") n <- c(2,4,8,16,32)
  if(any(is.na(n)) | (!is.numeric(n) && !is.integer(n)))
    stop("a numerical integer value for \"n\" must be provided")
  if(missing(nsim)){
    cat("\nenter the number of simultions sim, \n <return> will assume the default value 1000\n")
    nsim <- as.numeric(readline(prompt="nsim = "))
  }
  if(any(is.na(nsim)) | nsim == "") nsim <- 1000
  if(any(is.na(nsim)) |  (!is.numeric(nsim) && !is.integer(n)))
    stop("a numerical integer value for \"nsim\" must be provided")
  ##
  cat("\nsampling  ...  ")
  res <- list(data = x)
  for(nsz in n){
    sims <- matrix(0,nsim,nsz)
    for (i in 1:nsim)
      sims[i,] <- sample(x, nsz, replace = TRUE)
    xbar <- apply(sims, 1, mean)
    sd <- sqrt(apply(sims, 1, var))
    res[[paste("size", nsz, sep="")]] <- list(xbar = xbar, sd = sd)
  }
  class(res) <- "clt"
  cat("done.\n\n")
  if(plot){
    par(mfrow=c(ceiling((length(n)+1)/ncols),2),
        mar=c(3,2.5,2,.5), mgp=c(1.7,.7,0))
    plot.clt(res)
  }
  return(invisible(res))
}

"plot.clt" <- function(x, ...){
  hist(x$data, main = "", probability=TRUE)
  mtext("original population")
  nx <- length(x)
  lims <- function(y){
    ind.hist <- hist(y$xbar, probability=TRUE, plot=FALSE)
    return(c(range(ind.hist$breaks), range(ind.hist$dens)))
  }
  h.lims <- sapply(x[-1], lims)
  xymin <- apply(h.lims[c(1,3),,drop=FALSE], 1, min)
  xymax <- apply(h.lims[c(2,4),,drop=FALSE], 1, max)
  for(i in 2:nx){
    hist(x[[i]]$xbar, prob = TRUE, xlab=expression(bar(x)),
         ylab="density", main = "",
         xlim = c(xymin[1], xymax[1]), ylim = c(0, xymax[2]))
    mtext(paste("sample ",names(x)[i]))
  }
  return(invisible())
}

"clt.plot1" <- function(x, nsim) {
  data <- NULL
  for (i in 1:nsim) {
    data <- c(data, sample(x,1, replace=TRUE))
  }
  xl <- c(floor(min(data)-5),floor(max(data)+5))
  hist(data,xlim=xl,xlab="data",ylab="frequency")
  for (i in 1:nsim) {
    data <- c(data, mean(sample(x,2, replace=TRUE)))
  }
  hist(data,xlab="means of 2",ylab="frequency",xlim=xl)
  for (i in 1:nsim) {
    data <- c(data, mean(sample(x,4, replace=TRUE)))
  }
  hist(data,xlab="means of 4",ylab="frequency",xlim=xl)
  
  for (i in 1:nsim) {
    data <- c(data, mean(sample(x,8, replace=TRUE)))
  }
  hist(data,xlab="means of 8",ylab="frequency",xlim=xl)
}

"clt.plot2" <- function(nsim) {
  data(class98)
  xbar <- matrix(0,3,4)
  xvar <- xbar
  
  x <- class98[,1]
  x <- x[!is.na(x)]
  junk <- clt(x,1,nsim)
  xbar[1,1] <- mean(junk$xbar); xvar[1,1] <- var(junk$xbar)
  
  junk <- clt(x,2,nsim)
  xbar[1,2] <- mean(junk$xbar); xvar[1,2] <- var(junk$xbar)
  
  junk <- clt(x,4,nsim)
  xbar[1,3] <- mean(junk$xbar); xvar[1,3] <- var(junk$xbar)
  
  junk <- clt(x,8,nsim)
  xbar[1,4] <- mean(junk$xbar); xvar[1,4] <- var(junk$xbar)
  
  x <- class98[,2]
  x <- x[!is.na(x)]
  junk <- clt(x,1,nsim)
  xbar[2,1] <- mean(junk$xbar); xvar[2,1] <- var(junk$xbar)
  
  junk <- clt(x,2,nsim)
  xbar[2,2] <- mean(junk$xbar); xvar[2,2] <- var(junk$xbar)
  
  junk <- clt(x,4,nsim)
  xbar[2,3] <- mean(junk$xbar); xvar[2,3] <- var(junk$xbar)
  
  junk <- clt(x,8,nsim)
  xbar[2,4] <- mean(junk$xbar); xvar[2,4] <- var(junk$xbar)
  
  x <- -50*log(runif(50))
  x <- x[!is.na(x)]
  junk <- clt(x,1,nsim)
  xbar[3,1] <- mean(junk$xbar); xvar[3,1] <- var(junk$xbar)
  
  junk <- clt(x,2,nsim)
  xbar[3,2] <- mean(junk$xbar); xvar[3,2] <- var(junk$xbar)
  
  junk <- clt(x,4,nsim)
  xbar[3,3] <- mean(junk$xbar); xvar[3,3] <- var(junk$xbar)
  
  junk <- clt(x,8,nsim)
  xbar[3,4] <- mean(junk$xbar); xvar[3,4] <- var(junk$xbar)
  list(xbar=xbar, xvar=xvar)
}

